static char *SccsId = "@(#)edge.c 4.2 (TU-Delft) 08/28/90";
/**********************************************************

Name/Version      : makegln/4.2

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author            : N.P. van der Meijs
Creation date     : 15-Mar-1988
Modified by       :
Modification date :


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1988. All rights reserved.
**********************************************************/
#include "config.h"
#include <stdio.h>
#include "aux/aux.h"
#include "makegln.h"

static edge_t * freeList = NULL;

edge_t * newChain ();

edge_t *
createEdge (xl, yl, xr, yr, slope, sign)
coor_t xl, yl, xr, yr;
slope_t slope;
int sign;
{
    edge_t * e;

    if (freeList == NULL)
	freeList = newChain ();
    e = freeList;
    freeList = freeList -> fwd;

    e -> fwd = e -> bwd = e -> bundle = e -> next = (edge_t *) NULL;
    e -> xl = xl, e -> xr = xr;
    e -> yl = yl, e -> yr = yr;
    e -> slope = slope;
    e -> sign = sign;
    e -> signLeft = 0;
    e -> xc = e -> xr;
    e -> xi = INF;
    return (e);
}

disposeEdge (edge)
edge_t * edge;
{
    edge -> fwd = freeList;
    freeList = edge;
}

#define CHAIN_SIZE 1000
edge_t * newChain ()
{
    int i;
    edge_t * chain;
    chain = NEW (edge_t, CHAIN_SIZE);
    for (i = 0; i < CHAIN_SIZE - 1; i++)
	(chain + i) -> fwd = (chain + i + 1);
    (chain + CHAIN_SIZE - 1) -> fwd = NULL;		/* end of chain */

    return (chain);
}


extern int scale;

printEdge (s, edge)
char * s;
edge_t * edge;
{
    fprintf (stderr,
    "%s: xl: %g yl: %g xr: %g yr: %g xc: %g xi: %g slope: %d sign: %d signLeft: %d\n",
	s,
	(double) edge -> xl / scale, (double) edge -> yl / scale,
	(double) edge -> xr / scale, (double) edge -> yr / scale,
	(double) edge -> xc / scale, (double) edge -> xi / scale,
	edge -> slope, edge -> sign, edge -> signLeft);

    while (edge -> bundle) {
	edge = edge -> bundle;
	fprintf (stderr,
	    ">  %s: xl: %g yl: %g xr: %g yr: %g xc: %g xi: %g slope: %d sign: %d\n",
	    s, 
	    (double) edge -> xl / scale, (double) edge -> yl / scale,
	    (double) edge -> xr / scale, (double) edge -> yr / scale,
	    (double) edge -> xc / scale, (double) edge -> xi / scale,
	    edge -> slope, edge -> sign);
    }
}
