/* SccsId = "@(#)extract.h 4.4 (TU-Delft) 5/26/92" */
/**********************************************************

Name/Version      : space/4.4

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.J. van Genderen
		  : N.P. van der Meijs
Creation date     : 15-Mar-1988
Modified by       :
Modification date :


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1988. All rights reserved.
**********************************************************/
typedef struct nodePoint {
    coor_t x, y;
    struct subnode ** cons;
    struct nodePoint * next;
    struct nodePoint * prev;
    short fixed;
} nodePoint_t;

typedef struct contElemDef {
    int sortNr;
    int mask1;
    int con1;
    int mask2;
    int con2;
    double val;
} contElemDef_t;

typedef struct torElemDef {
    int gMask;
    int gCon;
    int dsMask;
    int dsCon;
    int cx;
} torElemDef_t;

typedef struct capElemDef {
    int sortNr;
    int pMask;
    int pCon;
    int pOccurrence;
    int nMask;
    int nCon;
    int nOccurrence;
    mask_t sBitPresent;
    mask_t sBitAbsent;
    mask_t oeBitPresent;
    mask_t oeBitAbsent;
    double val;
} capElemDef_t;

typedef struct resElemDef {
    int sortNr;
    int mask;
    int con;
    double val;
} resElemDef_t;

typedef struct meshElemDef {
    meshCoor_t z[2];
    meshCoor_t offset[2];
    int level [2];
    int link [2];
    int con;			/* conductor */
    unsigned char face[2];
} meshElemDef_t;

typedef struct vDimElemDef {
    int mask;
    int con;                    /* conductor */
    double height;
    double thickness;
} vDimElemDef_t;

typedef struct shapeElemDef {
    int mask;
    int con;                    /* conductor */
    double xb1;
    double xt1;
    double xb2;
    double xt2;
} shapeElemDef_t;

typedef struct elemDef {
    char name[MAX_ELEM_NAME + 1];
    int id;
    int cond;
    int cond_cnt;
    int type;
    union {
	resElemDef_t res;
	contElemDef_t cont;
	torElemDef_t tor;
	capElemDef_t cap;
	meshElemDef_t mesh; /* !!! OLD */
	vDimElemDef_t vdim;
	shapeElemDef_t shape;
    } s;
} elemDef_t;

typedef struct layerCond {
    int mask;
    int occurrence;
    int present;
} layerCond_t;

typedef struct keyTabSlot {
    elemDef_t **elements;
} keyTabSlot_t;

typedef struct tileBoundary {
    coor_t x1, y1;
    coor_t x2, y2;
    double length;
} tileBoundary_t;

typedef struct nPointRef {
    struct nPointRef * nextTl;
    struct nPointRef * nextRb;
    struct nodePoint * p;
} nPointRef_t;
