static char *SccsId = "@(#)say.c 4.6 (TU-Delft) 02/10/93";
/**********************************************************

Name/Version      : aux/4.6

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Authors           : A.J. van Genderen
                  : N.P. van der Meijs
Creation date     : 15-Mar-1988
Modified by       :
Modification date :


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1988. All rights reserved.
**********************************************************/
# include <stdio.h>
# include <ctype.h>
# include "bool.h"
# include "proto.h"

static bool_t verboseLevel = FALSE;

static FILE * fpout = stdout;
static FILE * fperr = stderr;

char * argv0 = NULL;

void verboseSetErrStream (fp)
FILE * fp;
{
    fperr = fp;
}

void verboseSetOutStream (fp)
FILE * fp;
{
    fpout = fp;
}

/* If message begins with a tab,
 * it is assumed to be a continuation message.
 * Don't print progname in front.
 */
/* VARARGS1 */
void say (s, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10)
char * s;
{
    if ((argv0 != NULL) && (*s != '\t'))
	fprintf (fperr, "%s: ",argv0);

    fprintf (fperr, s, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10);

    if (!(isspace (*(s + strlen (s) - 1))))
	fprintf (fperr, "\n");
    fflush (fperr);
}

void verboseSetMode (mode)
bool_t mode;
{
    verboseLevel = (mode == TRUE ? 1 : 0);
}

void verboseSetLevel (level)
bool_t level;
{
    verboseLevel = level;
}


/* VARARGS1 */
void verbose (s, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10)
char * s;
{
    if (verboseLevel > 0) 
	message (s, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10);
}

/*
 * If message <s> is not ended by whitespace, append
 * newline.
 */
/* VARARGS1 */
void message (s, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10)
char * s;
{
    fprintf (fpout, s, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10);
    if (!(isspace (*(s + strlen (s) - 1))))
	fprintf (fpout, "\n");
    fflush (fpout);
}

# ifdef DRIVER
main ()
{
    verboseSetMode (TRUE);

    verbose ("int 123: %d string <abc>: %s", 123, "abc");

    /* verbose ("double 1.2345: %g", 1.234); does not work */
}
# endif /* DRIVER */
