static char *SccsId = "@(#)plot.c 4.3 (TU-Delft) 01/28/93";
/**********************************************************

Name/Version      : aux/4.3

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Authors           : A.J. van Genderen
                  : N.P. van der Meijs
Creation date     : 15-Mar-1988
Modified by       :
Modification date :


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1988. All rights reserved.
**********************************************************/
#include <stdio.h>
#include "plot.h"

static char * styles[] = {
    "",			/* SOLID */
    "dotted",		/* DOTTED */
    "dashed"		/* DASHED */
};

static char * positions [] = {
    "",			/* CENTER */
    "above",		/* ABOVE */
    "below",		/* BELOW */
    "ljust",		/* LJUST */
    "rjust"		/* RJUST */
};

/*
 * An interface to produce .pic file.
 *
 * Open the plotfile, its name is <baseName>.pic
 */
PLOT_KEY * plotInit (baseName)
char * baseName;
{
    FILE * cfopen ();
    char buf[100];
    PLOT_KEY *fpPic;
    sprintf (buf, "%s.pic", baseName);

    fpPic = cfopen (buf, "w");
    fprintf (fpPic, ".PS 6i\n");
    return (fpPic);
}

/*
 * Close plotfile
 */
plotEnd (fp)
PLOT_KEY *fp;
{
    fprintf (fp, ".PE\n");
    fclose (fp);
}


/*
 * Draw a line from (x1,y1) to (x2,y2)
 * The linestyle is one of the defined names in plot.h
 */
plotLine (fp, style, x1, y1, x2, y2)
PLOT_KEY *fp;
int style;
int x1, y1, x2, y2;
{
    fprintf (fp, "line %s from %d,%d to %d,%d\n",
	styles[style], x1, y1, x2, y2);
}

/*
 * Plot a string <s> in pointsize <size> at <x>,<y>.
 * <adjust> is one of the names defined in plot.h
 */
plotString (fp, size, adjust, s, x, y)
PLOT_KEY * fp;
int size;
int adjust;
char * s;
int x, y;
{
    fprintf (fp, "\"\\s%d%s\\s0\" at %d,%d %s\n",
	size, s, x, y, positions[adjust]);
}
