static char *SccsId = "@(#)monit.c 4.3 (TU-Delft) 01/28/93";
/**********************************************************

Name/Version      : aux/4.3

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Authors           : A.J. van Genderen
                  : N.P. van der Meijs
Creation date     : 15-Mar-1988
Modified by       :
Modification date :


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1988. All rights reserved.
**********************************************************/

#include "stdio.h"
#include "sys/types.h"
#include "sys/times.h"

#define TRUE   1
#define FALSE  0

static struct tms timebuf;

static FILE * monit;

static long starttime;
static long stoptime;
static long ttprev;

/* 
 * Routines for monitoring program run time in a file
 * called <pname>.mon
 *
 * startmonitime - init monitoring of runtimes
 */
startmonitime (pname)
char *pname;
{
    char buf[20];
    FILE * cfopen ();
    long time ();     /* to initialize the monitoring part */

    sprintf (buf, "%s.mon", pname);
    monit = cfopen (buf, "w");

    fprintf (monit, "procedure             "); /* 22 */
    fprintf (monit, "        sys"); /* 11 */
    fprintf (monit, "       user");
    fprintf (monit, "      total");
    fprintf (monit, "        inc\n");
    fflush  (monit);
    starttime = time (0);
    ttprev = 0;
}

/* print <str>, together with current run times to .mon file.
 * <str> shouldn't be larger than 21 characters
 */
monitime (str)
char * str;
{
    long ttnow;
    int i;

    fprintf (monit, "%s", str);
    i = strlen (str);
    while (i < 22) {
	fprintf (monit, " ");
	i++;
    }

    times (&timebuf);

    printtime (timebuf.tms_stime);

    printtime (timebuf.tms_utime);

    ttnow = timebuf.tms_utime + timebuf.tms_stime;
    printtime (ttnow);

    printtime (ttnow - ttprev);

    fprintf (monit, "\n");
    fflush  (monit);

    ttprev = ttnow;
}

static printtime (t)    /* converts a long to a time expression and prints it */
long t;
{
    long h;
    long m;
    long s;
    long d;
    int flag;

    h = t / 216000;
    m = (t - h * 216000) / 3600;
    s = (t - h * 216000 - m * 3600) / 60;
    d = (t - h * 216000 - m * 3600 - s * 60) / 6;

    flag = FALSE;

    if (h > 0) {
        fprintf (monit, "%3d:", h);
	flag = TRUE;
    }
    else {
	fprintf (monit, "    ");
    }

    if (m > 0 || flag) {
	if (m < 10 && flag)
            fprintf (monit, "0%1d:", m);
	else 
            fprintf (monit, "%2d:", m);
	flag = TRUE;
    }
    else {
	fprintf (monit, "   ");
    }

    if (s < 10 && flag)
        fprintf (monit, "0%1d.", s);
    else
        fprintf (monit, "%2d.", s);
    fprintf (monit, "%d", d);
}

/*
 * Terminate monitoring.
 *
 * When startmonitime was called, this routine
 * should also be called (at the end of the program).
 */
stopmonitime ()
{
    long time ();

    stoptime = time (0);
    times (&timebuf);
    fprintf (monit, "effective time: %2d%%\n", 
    (timebuf.tms_utime + timebuf.tms_stime)
    * 100 / (60 * (stoptime - starttime)));

    fclose (monit);
}
