# if you want to compile with debugging, then do CCFLAG="-g" before sourcing
# this file
#

MAKE=make

if [ "X$X11LIB" = "X" ] ; then
   if [ "X$X11DIR" != "X" ] ; then
      X11LIB=$X11DIR/lib
   else
      X11LIB=/usr/lib/X11
   fi
fi
if [ "X$X11INCL" = "X" ] ; then
   if [ "X$X11DIR" != "X" ] ; then
      X11INCL=$X11DIR/include
   else
      X11INCL=/usr/include
   fi
fi
if [ "X$CCFLAG" = "X" ] ; then CCFLAG="-O" ; fi
CCMODE="$CCFLAG"
STATIC="-static"
#STATIC=""
X11OLIBS=""   # extra libs necessary to link X11 executables

ISGNU=`$MAKE -v -f/dev/null 2>/dev/null | fgrep GNU`
if [ "$ISGNU" = "" ] ; then
   echo ERROR: you _must_ use GNU make to build OCEAN and Nelsis/R3 ... 1>&2
   echo Install GNU make as \"${MAKE}\" somewhere in your PATH. 1>&2
   exit 1
fi

if [ "$GNU" = "" ] ; then
   LEX=lex
   LEXCOMPATIBLE=lex
   LEXLIB="-ll"      # for old fashioned LEX
else
   LEX=flex
   LEXCOMPATIBLE="flex -l"
   LEXLIB="-lfl"      # for new and better FLEX
fi

YACC=yacc
AR=ar ; export AR
RANLIB=ranlib ; export RANLIB
case "$MACHINE" in
    PA-RISC*)
         CC="cc $CCMODE -Wl,-a,archive"
	 ANSICC="$CC -Aa -D_HPUX_SOURCE $CCMODE"
	 CXX="g++ $CCMODE"
	 ARCHITECTURE=hp800HPUX90
	 OLIBS="$LEXLIB -lm -lbsdipc -lBSD"
	 OSTYPE=SYSV
         ;;
    "HP-PA_7")
         CC="cc $CCMODE"
	 ANSICC="$CC -Aa -D_HPUX_SOURCE $CCMODE"
	 ARCHITECTURE=hp800HPUX70
	 OLIBS="$LEXLIB -lm -lbsdipc -lBSD"
	 OSTYPE=SYSV
         ;;
    "HP-PA_8")
         CC="cc $CCMODE -Wl,-a,archive"
	 ANSICC="$CC -Aa -D_HPUX_SOURCE $CCMODE"
	 CXX="g++ $CCMODE"
	 ARCHITECTURE=hp800HPUX80
	 OLIBS="$LEXLIB -lm -lbsdipc -lBSD"
	 OSTYPE=SYSV
         ;;
    "HP-PA_9")
         CC="cc $CCMODE -Wl,-a,archive"
	 ANSICC="$CC -Aa -D_HPUX_SOURCE"
	 CXX="g++ $CCMODE"
	 ARCHITECTURE=hp800HPUX90
	 OLIBS="$LEXLIB -lm -lbsdipc -lBSD"
	 OSTYPE=SYSV
         ;;
    "sun4_4")
         STATIC="-Bstatic"
         CC="cc $CCMODE ${STATIC}"
	 ANSICC="$CC -ansi"
	 CXX="g++ $CCMODE ${STATIC}"
	 ARCHITECTURE=sun
	 OLIBS="$LEXLIB -lm"
	 OSTYPE=BSD
         ;;
    "sun4_5")
	 STATIC=""
         CC="cc -DSYSV $CCMODE ${STATIC}"
	 ANSICC="$CC -ansi"
	 CXX="g++ $CCMODE ${STATIC}"
	 ARCHITECTURE=sunSolaris
	 OLIBS="$LEXLIB -lm -lnsl -lsocket"
	 OSTYPE=SYSV
         ;;
    *Linux*)
         CC="cc -traditional -fno-builtin $CCMODE ${STATIC}"
         ANSICC="cc -ansi -fno-builtin $CCMODE ${STATIC}"
	 CXX="g++ $CCMODE ${STATIC}"
	 ARCHITECTURE=gnu
	 OLIBS="-lm -lfl"
	 X11OLIBS="-lSM -lICE"
	 OSTYPE=SYSV
         ;;
    SGI_IRIX5|mips_5)
	 STATIC=""
         CC="cc -cckr $CCMODE ${STATIC}"
         ANSICC="cc -ansi $CCMODE ${STATIC}"
	 CXX="g++ $CCMODE ${STATIC}"
	 ARCHITECTURE=gnu
	 OLIBS="$LEXLIB -lm"
	 RANLIB=/bin/true
	 OSTYPE=BSD
	 YACC="bison -y"
         ;;
    *)
	 STATIC=""
         echo WARNING: unknown MACHINE environment ...
         CC="cc $CCMODE"
         ANSICC="$CC"
	 CXX="g++ $CCMODE"
	 ARCHITECTURE=gnu
	 OLIBS="$LEXLIB -lm"
	 if [ -f /usr/include/ndir.h ] ; then
	    OSTYPE=SYSV
	 else
	    OSTYPE=BSD
	 fi
         ;;
esac
if [ "X$GNU" != "X" ] ; then
         CC="gcc -fno-builtin -traditional $CCMODE $STATIC"
         ANSICC="gcc -fno-builtin -ansi $CCMODE $STATIC"
         YACC="bison -y"
fi
if [ "X$ICDPATH" != "X" ] ; then
   SRCDIR=$ICDPATH/src
else
   case "$MACHINE" in
      "sun*")
         SRCDIR=/users/ocean_src/cacd/src
         ;;
      *)
         SRCDIR=/usr/ocean/cacd/src
         ;;
   esac
   ICDPATH=`dirname $SRCDIR`
fi
#add support for memory and string managers in libmnew.a:
OLIBS="$OLIBS -lmnew"
LD="$CC -L$ICDPATH/lib/$MACHINE"
LDXX="$CXX -L$ICDPATH/lib/$MACHINE"
OCFLAGS=""
if [ ! -d "$SRCDIR" ] ; then
   echo WARNING: sourcedir \"${SRCDIR}\" does not exist ...
fi

# following for NEWSTUFF Makefiles:
NELSISHOME=$ICDPATH
CACDSRCHOME=$ICDPATH

domake()
{
  $MAKE ICDPATH=$ICDPATH ANSICC="$ANSICC" CC="$CC" CXX="$CXX" LD="$LD" LDXX="$LDXX" \
        OCFLAGS="$OCFLAGS" OLIBS="$OLIBS" OSTYPE=$OSTYPE YACC="$YACC" LEX="$LEX" \
        LEXCOMPATIBLE="$LEXCOMPATIBLE" X11LIB="$X11LIB" X11INCL="$X11INCL" \
	X11OLIBS="$X11OLIBS" \
        $*
}
