# if you want to compile with debugging, setenv CCFLAG "-g"
#
if ( ! $?X11LIB ) then
   if ( $?X11DIR) then
      setenv X11LIB "$X11DIR/lib"
   else
      setenv X11LIB /usr/X11/lib
   endif
endif
if ( ! $?X11INCL ) then
   if ( $?X11DIR ) then
      setenv X11INCL $X11DIR/include
   else
      setenv X11INCL /usr/include
   endif
endif
if (! $?CCFLAG) setenv CCFLAG "-O"
setenv CCMODE "$CCFLAG"
set STATIC="-static"

switch ($MACHINE)
    case "PA-RISC*":
         setenv CC "cc $CCMODE -Wl,-a,archive"
	 setenv ANSICC "$CC -Aa -D_HPUX_SOURCE"
	 setenv CXX "g++ $CCMODE"
	 setenv ARCHITECTURE hp800HPUX90
	 setenv OLIBS "-ll -lm -lbsdipc -lBSD"
	 setenv OSTYPE SYSV
         breaksw
    case "HP-PA_7":
         setenv CC "cc $CCMODE"
	 setenv ANSICC "$CC -Aa -D_HPUX_SOURCE"
	 setenv ARCHITECTURE hp800HPUX70
	 setenv OLIBS "-ll -lm -lbsdipc -lBSD"
	 setenv OSTYPE SYSV
         breaksw
    case "HP-PA_8":
         setenv CC "cc $CCMODE -Wl,-a,archive"
	 setenv ANSICC "$CC -Aa -D_HPUX_SOURCE"
	 setenv CXX "g++ $CCMODE"
	 setenv ARCHITECTURE hp800HPUX80
	 setenv OLIBS "-ll -lm -lbsdipc -lBSD"
	 setenv OSTYPE SYSV
         breaksw
    case "HP-PA_9":
         setenv CC "cc $CCMODE -Wl,-a,archive"
	 setenv ANSICC "$CC -Aa -D_HPUX_SOURCE"
	 setenv CXX "g++ $CCMODE"
	 setenv ARCHITECTURE hp800HPUX90
	 setenv OLIBS "-ll -lm -lbsdipc -lBSD"
	 setenv OSTYPE SYSV
         breaksw
    case "sun4_4":
         setenv CC "cc $CCMODE -Bstatic"
	 setenv ANSICC "$CC -ansi"
	 setenv CXX "g++ $CCMODE"
	 setenv ARCHITECTURE sun
	 setenv OLIBS "-ll -lm"
	 setenv OSTYPE BSD
         breaksw
    case "sun4_5":
	 set STATIC=""
         setenv CC "cc -DSYSV $CCMODE"
	 setenv ANSICC "$CC -ansi"
	 setenv CXX "g++ $CCMODE"
	 setenv ARCHITECTURE sunSolaris
	 setenv OLIBS "-ll -lm -lnsl -lsocket"
	 setenv OSTYPE SYSV
         breaksw
    case "*Linux*":
         setenv CC "cc -traditional -fno-builtin $CCMODE -static"
         setenv ANSICC "cc -ansi -fno-builtin $CCMODE -static"
	 setenv CXX "g++ $CCMODE"
	 setenv ARCHITECTURE gnu
	 setenv OLIBS "-lm -lfl"
	 setenv OSTYPE SYSV
         breaksw
    default:
         echo WARNING: unknown MACHINE environment ...
         setenv CC "cc $CCMODE"
         setenv ANSICC "$CC"
	 setenv CXX "CC $CCMODE"
	 setenv ARCHITECTURE gnu
	 setenv OLIBS "-ll -lm"
	 if (-f /usr/include/ndir.h ) then
	    setenv OSTYPE SYSV
	 else
	    setenv OSTYPE BSD
	 endif
         breaksw
endsw
setenv YACC yacc
if ($?GNU) then
         setenv CC "gcc -fno-builtin -traditional $CCMODE $STATIC"
         setenv ANSICC "gcc -fno-builtin -ansi $CCMODE $STATIC"
         setenv YACC "bison -y"
         #setenv ARCHITECTURE gnu
endif   
if ($?ICDPATH) then
   setenv SRCDIR $ICDPATH/src
else
   switch ($MACHINE)
      case "sun*":
         setenv SRCDIR /users/ocean_src/cacd/src
         breaksw
      default:
         setenv SRCDIR /usr/ocean/cacd/src
         breaksw
   endsw
   setenv ICDPATH `dirname $SRCDIR`
endif
#add support for memory and string managers in libmnew.a:
setenv OLIBS "$OLIBS -lmnew"
setenv LD "$CC -L$ICDPATH/lib/$MACHINE"
setenv LDXX "$CXX -L$ICDPATH/lib/$MACHINE"
setenv LEX "flex"
setenv LEXCOMPATIBLE "flex -l"
setenv RANLIB ranlib
setenv AR ar
setenv OCFLAGS ""
if ( ! -d $SRCDIR ) then
   echo WARNING: sourcedir \"${SRCDIR}\" does not exist ...
endif

# following for NEWSTUFF Makefiles:
setenv NELSISHOME $ICDPATH
setenv CACDSRCHOME $ICDPATH

setenv MAKE make

alias domake '$MAKE ICDPATH=$ICDPATH ANSICC="$ANSICC" CC="$CC" CXX="$CXX" LD="$LD" LDXX="$LDXX" OCFLAGS="$OCFLAGS" OLIBS="$OLIBS" OSTYPE=$OSTYPE YACC="$YACC" LEX="$LEX" LEXCOMPATIBLE="$LEXCOMPATIBLE" X11LIB="$X11LIB" X11INCL="$X11INCL" \!*'
