static char *SccsId = "@(#)sort.c 4.1 (TU-Delft) 05/23/90";
/**********************************************************

Name/Version      : sls_exp/4.1

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.J. van Genderen
Creation date     : 10-Jul-1986
Modified by       : S. de Graaf
Modification date : 10-Jul-1986


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1986 , All rights reserved
**********************************************************/
#include "extern.h"

sort () {             /* sorts name table elements from mcs_NT_cnt to NT_cnt  */
    NAMETABLE * nt;   /* into lexographical order.  the routine automatically */
    int cnt;          /* updates the references concerned.                    */
    int number;       /* this procedure beter not be called after compact()   */
    int up;
    int low;
    int xtx;
    int x;
    int xt_cnt;
    int qs_nmcmp ();

    qsort ((char *)(NT + mcs_NT_cnt), (unsigned)(NT_cnt - mcs_NT_cnt), 
	   sizeof (NAMETABLE), qs_nmcmp);                   /* quicksort */
	
    /* update the references to the NT[] elements */

    nt = NT + mcs_NT_cnt;
    for (cnt = mcs_NT_cnt; cnt < NT_cnt; cnt++) { 
	number = 1;
	if ( nt -> xtx >= 0 ) {
	    xtx = nt -> xtx;
	    for (xt_cnt = XT[ xtx++ ]; xt_cnt > 0; xt_cnt--) {
		low = XT[ xtx++ ];
		up = XT[ xtx++ ];
		number = number * ( up - low + 1 );
	    }
	}
	switch ( nt -> sort ) {   
	    case Node :
	    case Node_t :
		x = nt -> x;
		if ( nt -> xtx < 0 ) {
		    N[ x ].ntx = cnt;
		}
		else {
		    while (number-- > 0)
		        N[ XX[x++] ].ntx = cnt;
		}
		break;
	    case Modelcall :
		x = nt -> x;
		while (number-- > 0)
		    MCT[ x++ ].ntx = cnt;
		break;
	    default :
		/* Transistor, Intercap and Functional have no  */
		/* reference back to the name table, so nothing */
		/* has to be updated then                       */
		break;
	}
	nt++;
    }
}

int qs_nmcmp (el1, el2)  /* compares two names of the name table NT[] */
NAMETABLE * el1;
NAMETABLE * el2;
{
    return ( strcmp (ST + el1 -> name, ST + el2 -> name) );
}
