static char *SccsId = "@(#)getterm.c 4.2 (TU-Delft) 06/18/90";
/**********************************************************

Name/Version      : sls_exp/4.2

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.J. van Genderen
Creation date     : 10-Jul-1986
Modified by       : S. de Graaf
Modification date : 10-Jul-1986


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1986 , All rights reserved
**********************************************************/
#include "extern.h"

getterm (m)   /* gets the interfaces (terminals) of model m */
DM_CELL * m;
{
    DM_STREAM * dsp;
    char fn_term[50];
    int up;
    int low;
    int nbr;
    int i;
    int ntx;
    int nx;
    int xx;
    int new;

    sprintf (fn_term, "circuit/%s/term", m -> cell);

    dsp = dmOpenStream (m, "term", "r");

    while (dmGetDesignData (dsp, CIR_TERM) > 0) {

        ntx = newname (cterm.term_name);
	NT[ ntx ].sort = Node_t;

	nbr = 1;
        if (cterm.term_dim > 0) {
	    new = NT[ntx].xtx = newxt ();
	    XT[ new ] = cterm.term_dim;
            for (i = 0; i < cterm.term_dim; i++) {
                low = cterm.term_lower[i];
                up = cterm.term_upper[i];
		new = newxt ();
		XT[ new ] = low;
		new = newxt ();
		XT[ new ] = up;
		nbr = nbr * (up - low + 1);
	    }
        }

        if (cterm.term_dim <= 0) {
	    nx = newnode ();
	    NT[ ntx ].x = nx;
	    N[ nx ].ntx = ntx;
	}
	else {
	    xx = newxx (nbr) - nbr + 1;
	    NT[ ntx ].x = xx;
	    while (nbr-- > 0) {
		nx = newnode ();
		XX[ xx++ ] = nx;
	        N[ nx ].ntx = ntx;
	    }
	}
        if (cterm.term_lower != NULL)
            CFREE (cterm.term_lower);
        if (cterm.term_upper != NULL)
            CFREE (cterm.term_upper);
        if (cterm.term_attribute != NULL)
            CFREE (cterm.term_attribute);
    }

    dmCloseStream (dsp, COMPLETE);
}
