%{
/* SccsId = "@(#)procp_l.l 4.3 (TU-Delft) 06/22/93" */
/**********************************************************

Name/Version      : sls/4.3

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.C. de Graaf, A.J. van Genderen
Creation date     : 10-Jul-1986
Modified by       : S. de Graaf
Modification date : 10-Jul-1986


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1986 , All rights reserved
**********************************************************/

#ifdef FLEX_SCANNER
int yylineno = 0;
#define YYINCR(_count) yylineno += _count /* have to do this ourselves ... */
#else
#define YYINCR(_x)
#endif

%}

%%
"/*"			{  int thechar;
			   loop:
				while((thechar = input()) != '*')
				{
				    if(thechar == EOF) return(0);
				}
				switch(input())
				{
				    case  0 : return(0);
				    case '/': break;
				    case '*': unput('*');
				    default : goto loop;
				}
			}
vh			{ return(VH); }
vswitch			{ return(VSWITCH); }
vminh			{ return(VMINH); }
vmaxl			{ return(VMAXL); }
krise			{ return(KRISE); }
kfall			{ return(KFALL); }
nenh			{ return(NENH); }
penh			{ return(PENH); }
ndep			{ return(NDEP); }
end			{ return(END); }
pullup			{ return(PULLUP); }
pulldown		{ return(PULLDOWN); }
passup			{ return(PASSUP); }
passdown		{ return(PASSDOWN); }
load			{ return(LOAD); }
superload		{ return(SUPERLOAD); }
rstat			{ return(RSTAT); }
rsatu			{ return(RSATU); }
cgstat			{ return(CGSTAT); }
cgrise			{ return(CGRISE); }
cgfall			{ return(CGFALL); }
cestat			{ return(CESTAT); }
cerise			{ return(CERISE); }
cefall			{ return(CEFALL); }
rdyn			{ return(RDYN); }
cch			{ return(CCH); }
loffset			{ return(LOFFSET); }
woffset			{ return(WOFFSET); }
l			{ return(L); }
w			{ return(W); }
=			{ return(EQUAL); }
:			{ return(COLON); }
-?[0-9]+		{ yylval.sval = yytext;
			  return(INT); }
-?[0-9]+("."[0-9]+)?k   { yylval.fval = 1e3 * atof(yytext);
			  return(FLO); }
-?[0-9]+("."[0-9]+)?    { yylval.fval = atof(yytext);
			  return(FLO); }
-?[0-9]+("."[0-9]+)?m   { yylval.fval = 1e-3 * atof(yytext);
			  return(FLO); }
-?[0-9]+("."[0-9]+)?u   { yylval.fval = 1e-6 * atof(yytext);
			  return(FLO); }
-?[0-9]+("."[0-9]+)?n   { yylval.fval = 1e-9 * atof(yytext);
			  return(FLO); }
-?[0-9]+("."[0-9]+)?p   { yylval.fval = 1e-12 * atof(yytext);
			  return(FLO); }
-?[0-9]+("."[0-9]+)?f   { yylval.fval = 1e-15 * atof(yytext);
			  return(FLO); }
[\t ]+			;
[\n]+                   {YYINCR(yyleng);}
%%
