static char *SccsId = "@(#)plot.c 4.5 (TU-Delft) 10/09/92";
/**********************************************************

Name/Version      : sls_exp/4.5

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.J. van Genderen
Creation date     : 01-Dec-1986
Modified by       : 
Modification date :


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1986 , All rights reserved
**********************************************************/
#include "extern.h"

FILE * fp_plt = NULL;
lastplottime = -1;

static int *PX;
int PX_cnt;

DM_STREAM * dsp_plt;

plot_addname (path)
PATH_SPEC * path;
{
    STRING_REF * str_ref;
    STRING_REF * names_from_path ();

    str_ref = names_from_path (0, path);

    if (fp_plt == NULL) {
        if (use_io_views) {
            dsp_plt = dmOpenStream (simout_key, "plt", "w");
            fp_plt = dsp_plt -> dmfp;
        }
        else
	    OPENW (fp_plt, fn_plt);
        fprintf (fp_plt, "%12d \n", 0);  /* space for number of signals */
    }

    while (str_ref != NULL) {
        fprintf (fp_plt, "%s\n", str_ref -> str);
        str_ref = str_ref -> next;
    }
}

plot_scale ()
{
    long fremem;

    if (fp_plt != NULL) {
        fremem = ftell (fp_plt);
        fseek (fp_plt, 0L, 0);
        fprintf (fp_plt, "%12d", plotnodes_cnt);
        fseek (fp_plt, fremem, 0);
        fprintf (fp_plt, "%e\n", inttimeaccur);
        if (vHtmp > 0)
            fprintf (fp_plt, "%e\n", (float)vHtmp / (float)VOLTMAX_INT);
        else
            fprintf (fp_plt, "%e\n", (float)5 / (float)VOLTMAX_INT);
        fprintf (fp_plt, "%d ", 0);
        fprintf (fp_plt, "%d\n", VOLTMAX_INT);
    }
}

plot_node (n, bound, v)
NODE * n;
char bound;
int v;
{
    int cnt;
    int x;

    x = n -> plot + 1;
    for (cnt = PX[n -> plot]; cnt > 0; cnt--) {
	plot_index (PX[x], bound, v);
	x++;
    }
}

plot_index (x, bound, v)
int x;
char bound;
int v;
{
    if (lastplottime != tcurr) {
	fflush (fp_plt);
        if (lastplottime >= 0)
            fprintf (fp_plt, "\n%d", tcurr);
        else
            fprintf (fp_plt, "%d", tcurr);
        lastplottime = tcurr;
    }

    fprintf (fp_plt, " %d%c %d", x, bound, v);
}

plot_begin ()
{
    NODE_REF_LIST * plt_ref;
    UPAIR * up;
    int i;
    int newPX_cnt;
    int p_cnt;
    int x;
    UPAIR * uminmax ();

    if (fp_plt != NULL) {

	if (plotl_begin != NULL) {

	    /* create PX[] */

	    PALLOC (PX, 1 + plotnodes_cnt * 2, int);

	    /* make N[].plot point to an index of PX[],
	       and fill PX[] (partly) with number of through-references */

	    PX_cnt = 1;  /* !!! */
	    for (i = 0; i < N_cnt; i++) {
		if (N[i].plot > 0) {
		    newPX_cnt = PX_cnt + 1 + N[i].plot;
		    PX[PX_cnt] = N[i].plot;
		    N[i].plot = PX_cnt;
		    PX_cnt++;
		    while (PX_cnt < newPX_cnt) {
			PX[PX_cnt] = -1;  /* indicating empty position */
			PX_cnt++;
		    }
		}
	    }

            /* create references from PX[] to indices in plotfile */

	    plt_ref = plotl_begin;
	    p_cnt = 1;
	    while (plt_ref != NULL) {
		if (plt_ref -> nx >= 0) {
		    i = N[plt_ref -> nx].plot;
		    while (PX[i] >= 0)
			i++;
		    PX[i] = p_cnt++;  
		}
		plt_ref = plt_ref -> next;
	    }
	}

        plt_ref = plotl_begin;
	x = 1;
        while (plt_ref != NULL) {
            if (plt_ref -> nx >= 0) {
                up = uminmax (&N[plt_ref -> nx]);
                plot_index (x, 'l', (int)(up -> umin));
                plot_index (x, 'u', (int)(up -> umax));
		x++;
            }
            plt_ref = plt_ref -> next;
        }

	fflush (fp_plt);
    }
}

plot_end ()
{
    NODE_REF_LIST * plt_ref;
    UPAIR * up;
    int x;
    UPAIR * uminmax ();

    if (fp_plt != NULL) {

        plt_ref = plotl_begin;
	x = 1;
        while (plt_ref != NULL) {
            if (plt_ref -> nx >= 0) {
                up = uminmax (&N[plt_ref -> nx]);
                plot_index (x, 'l', (int)(up -> umin));
                plot_index (x, 'u', (int)(up -> umax));
		x++;
            }
            plt_ref = plt_ref -> next;
        }
        fprintf (fp_plt, "\n");
        if (use_io_views) {
            dmCloseStream (dsp_plt, COMPLETE);
            fp_plt = NULL;
        }
        else
	    fclose (fp_plt);
    }
}
