static char *SccsId = "@(#)monit.c 4.1 (TU-Delft) 05/23/90";
/**********************************************************

Name/Version      : sls_exp/4.1

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.J. van Genderen
Creation date     : 10-Jul-1986
Modified by       : S. de Graaf
Modification date : 10-Jul-1986


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1986 , All rights reserved
**********************************************************/
/* 
 * Routines for monitoring program run time in a file called mon
 */

#include "stdio.h"
#include "sys/types.h"
#include "sys/times.h"

#define TRUE   1
#define FALSE  0

#if defined (hp9000s800)
#define  HZ  100
#else
#if defined (hp9000s300)
#define  HZ   50
#else
#define  HZ   60
#endif
#endif

struct tms timebuf;

FILE * monit;

long starttime;
long stoptime;
long ttprev;

/* at the start this routine has to be called */
startmonitime (pname)
char *pname;
{
    char buf[20];
    long time ();     /* to initialize the monitoring part */

    sprintf (buf, "%s.mon", pname);
    if ( (monit = fopen (buf, "w")) == NULL ) {
	fprintf (stderr, "Cannot open file %s\n", buf);
	exit (1);
    }

    fprintf (monit, "procedure             "); /* 22 */
    fprintf (monit, "        sys"); /* 11 */
    fprintf (monit, "       user");
    fprintf (monit, "      total");
    fprintf (monit, "        inc\n");
    starttime = time (0);
    ttprev = 0;
}

monitime (str)   /* prints str, together with current run times. */
char * str;      /* str shouldn't be larger than 21 characters.  */
{
    long ttnow;
    int i;

    fprintf (monit, "%s", str);
    i = strlen (str);
    while (i < 22) {
	fprintf (monit, " ");
	i++;
    }

    times (&timebuf);

    printtime (timebuf.tms_stime);

    printtime (timebuf.tms_utime);

    ttnow = timebuf.tms_utime + timebuf.tms_stime;
    printtime (ttnow);

    printtime (ttnow - ttprev);

    fprintf (monit, "\n");

    ttprev = ttnow;
}

printtime (t)    /* converts a long to a time expression and prints it */
long t;
{
    long h;
    long m;
    long s;
    long d;
    int flag;

    h = t / (3600 * HZ);
    m = (t - h * 3600 * HZ) / (60 * HZ);
    s = (t - h * 3600 * HZ - m * 60 * HZ) / HZ;
    d = (t - h * 3600 * HZ - m * 60 * HZ - s * HZ) / (HZ * 0.10);

    flag = FALSE;

    if (h > 0) {
        fprintf (monit, "%3d:", h);
	flag = TRUE;
    }
    else {
	fprintf (monit, "    ");
    }

    if (m > 0 || flag) {
	if (m < 10 && flag)
            fprintf (monit, "0%1d:", m);
	else 
            fprintf (monit, "%2d:", m);
	flag = TRUE;
    }
    else {
	fprintf (monit, "   ");
    }

    if (s < 10 && flag)
        fprintf (monit, "0%1d.", s);
    else
        fprintf (monit, "%2d.", s);
    fprintf (monit, "%d", d);
}

stopmonitime () {     /* at the end of the monitoring this routine has */
    long time ();     /* to be called                                  */

    stoptime = time (0);
    times (&timebuf);
    fprintf (monit, "effective time: %2d%%\n", 
    (timebuf.tms_utime + timebuf.tms_stime)
    * 100 / (HZ * (stoptime - starttime)));

    fclose (monit);
}
