static char *SccsId = "@(#)main.c 3.1 (TU-Delft) 04/16/87";
/**********************************************************

Name/Version      : sldm/3.1

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : N. van der Meijs
Creation date     : 17-Oct-1984
Modified by       :
Modification date :


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1984 , All rights reserved
**********************************************************/
# include "sldm.h"

/*
 * global definitions for sldm
 */

FILE * ofp = stdout;
char infile[MAXPATH + 1];
char *statement = NULL;
int  xval[MAXVALS + 1];
int  yval[MAXVALS + 1];


#define nextarg (++argv, --argc)

extern  FILE * yyin;
extern  int    yydebug;

static char   *Usage =
	"sldm [-x v1 v2 ...] [-y v1 v2 ...] [--] [file1 ...]";

/* main - sldm main routine, stretch preprocessor for ldm */

main (argc, argv)
int     argc;
char   *argv[];
{
    void exit ();
    void perror ();
    char * strncpy ();
    boolean isnum ();
    boolean filter = TRUE;
    boolean files = FALSE;
    xval[0] = 0;
    yval[0] = 0;

    nextarg;
    while (argc > 0) {
	if (**argv != '-' || files == TRUE) {
	    filter = FALSE;
	    strncpy (infile, *argv, MAXPATH);
	    infile[MAXPATH] = EOS;
	    yyin = fopen (infile, "r");
	    if (!yyin) {
		fprintf (stderr, "sldm: ");
		perror (infile);
		nextarg;
		continue;
	    }
	    (void) yyparse ();
	    (void) fclose (yyin);
	    nextarg;
	}
	else if (strcmp ("-x", *argv) == 0) {/* equal */
	    nextarg;
	    xval[0] = 0;
	    while (argc > 0 && isnum (*argv)) {
		if (xval[0] == MAXVALS) {
		    die ("More than %d stretch args. in x-direction", MAXVALS);
		}
		xval[++xval[0]] = atoi (*argv);
		nextarg;
	    }
	    continue;		/* start outer while again */
	}
	else  if (strcmp ("-y", *argv) == 0) {/* equal */
	    nextarg;
	    yval[0] = 0;
	    while (argc > 0 && isnum (*argv)) {
		if (yval[0] == MAXVALS) {
		    die ("More than %d stretch args. in y-direction", MAXVALS);
		}
		yval[++yval[0]] = atoi (*argv);
		nextarg;
	    }
	    continue;		/* start outer while again */
	}

# ifdef notdef
	else  if (strcmp ("-n", *argv) == 0) {
	    if (nextarg) {	/* this argument gives a new model name */
		installName (*argv);
		nextarg;
	    }
	}
# endif notdef

# ifdef DEBUG
        else if (strcmp ("-d", *argv) == 0) {
	    nextarg;
	    yydebug = 1;	/* parser debugging */
	}
# endif DEBUG
	else if (strcmp ("--", *argv) == 0) {
	    nextarg;
	    files = TRUE;
	}
	else {
	    fprintf (stderr, "sldm: bad option: %s\n", *argv);
	    fprintf (stderr, "Usage: %s\n", Usage);
	    exit (1);
	    nextarg;
	}
    }
    if (filter) {
	strcpy (infile, "<stdin>");
	(void) yyparse ();
    }
}

/* isnum - is argument string a number? */

#include <ctype.h>
static boolean isnum (s)
char   *s;
{
    if (*s == '+' || *s == '-')
	s++;
    while (isdigit (*s))
	s++;
    return (*s == EOS ? TRUE : FALSE);
}
