static char *SccsId = "@(#)install.c 3.2 (TU-Delft) 05/15/87";
/**********************************************************

Name/Version      : sldm/3.2

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : N. van der Meijs
Creation date     : 17-Oct-1984
Modified by       :
Modification date :


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1984 , All rights reserved
**********************************************************/
# include "sldm.h"


static STRETCH  * xptr,
		* yptr,
		* xroot,
		* yroot,
		* xend,
		* yend;
static  int oldx = 0,
            oldy = 0;

/* install, lookup - install and lookup a stretch node */

STRETCH * install (ptr)
STRETCH * ptr;
{

    if (ptr -> dir == XDIR) {
	ptr -> prev = xend;
	if (xend) {
	    xend -> next = ptr;
	    xend = ptr;
	}
	else 
	    xptr = xroot = xend = ptr;
    }
    else  if (ptr -> dir == YDIR) {
	ptr -> prev = yend;
	if (yend) {
	    yend -> next = ptr;
	    yend = ptr;
	}
	else 
	    yptr = yroot = yend = ptr;
    }
    else  {
	PANIC ("bad direction: '%d'", ptr -> dir);
	ptr = NULL;
    }
    ptr -> next = NULL;
    return (ptr);
}

STRETCH * lookup (index, dir)
int     index,
        dir;
{
    if (dir == XDIR) {
	if (index == 0) {
	    oldx = 0;
	    xptr = xroot;
	}
	while (oldx < index) {
	    if (!(xptr -> next))
		return (NULL);
	    xptr = xptr -> next;
	    oldx++;
	}
	while (oldx > index) {
	    if (!(xptr -> prev))
		return (NULL);
	    xptr = xptr -> prev;
	    oldx--;
	}
	return (xptr);
    }
    else  if (dir == YDIR) {
	if (index == 0) {
	    oldy = 0;
	    yptr = yroot;
	}
	while (oldy < index) {
	    if (!(yptr -> next))
		return (NULL);
	    yptr = yptr -> next;
	    oldy++;
	}
	while (oldy > index) {
	    if (!(yptr -> prev))
		return (NULL);
	    yptr = yptr -> prev;
	    oldy--;
	}
	return (yptr);
    }
    else  {
	PANIC ("bad direction: '%d'", dir);
	return (NULL);
    }
}

/* deleteStretch - delete x- and y-list of stretch nodes */

void deleteStretch () 
{
    void free ();
    while (xroot != NULL) {
	xptr = xroot -> next;
	free ((char *) xroot);
	xroot = xptr;
    }
    while (yroot != NULL) {
	yptr = yroot -> next;
	free ((char *) yroot);
	yroot = yptr;
    }
    xroot = yroot = xptr = yptr = xend = yend = NULL;
    oldx = oldy = 0;
}

/* createStretch - create a STRETCH node */

# ifdef notdef
!!!! - not used - !!!
STRETCH * createStretch (label, pos, lo, hi, val, dir, line)
int     label, pos, lo, hi, val,
        dir,
        line;
{
    STRETCH * sp;

    if ((sp = alloc (STRETCH)) == NULL)
	die ("no more core\n");

    sp -> label = label;
    sp -> pos = pos;
    sp -> lo = lo;
    sp -> hi = hi;
    sp -> val = val;
    sp -> dir = dir;
    sp -> line = line;
    return (sp);
}
#endif notdef
