/* SccsId = "@(#)define.h 4.7.1.2 (TU-Delft) 10/20/95" */
/**********************************************************

Name/Version      : simeye/4.7.1.2

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.J. van Genderen
Creation date     : 29-May-1990
Modified by       : 
Modification date : 


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1990 , All rights reserved
**********************************************************/

#define MAXTYPE(type)  ((type)(~(((unsigned type)1)<<(8*(int)sizeof(type))-1)))
#ifndef MAXINT
#define MAXINT	        MAXTYPE(int)
#endif
#ifndef MAXLONG
#define MAXLONG	        MAXTYPE(long)
#endif

#define Min(a,b)  ((a)<(b)?(a):(b))
#define Max(a,b)  ((a)>(b)?(a):(b))
#define Abs(a)    ((a)>=0?(a):(-(a)))

#define NEW(ptr, nel, type)                                                \
    if ((ptr = (type *)calloc ((unsigned)(nel), sizeof (type))) == NULL) { \
	fprintf (stderr, "Cannot allocate storage\n");                     \
	die (1);                                                          \
    }

#define ENLARGE(ptr, nel, type)                                              \
    if ((ptr =                                                               \
	  (type *)realloc (ptr, (unsigned)(nel * sizeof (type)))) == NULL) { \
	fprintf (stderr, "Cannot allocate storage\n");                      \
	die (1);                                                          \
    }

#define DELETE(ptr)       if (ptr) cfree (ptr)

#define ZOOMIN      1
#define ZOOMOUT     2
#define MEASURE     3
#define SHUFFLE     4
#define QUITP       5
#define SIMULATE    6
#define EXTRACT     7
#define HARDCOPY    8

#define UNIT        11
#define NEWSIG      12
#define DELSIG      13
#define COPYSIG     14
#define CHANGE      15
#define YANK        16
#define PUT         17
#define SPEED       18
#define TEND        19
#define WRITE       20
#define CLEARALL    21

#define STIMULI  "stimuli"
#define SIMOUT   "simout"

#ifndef NCF_RELEASE
#define NCF_RELEASE     300
#endif /* NCF_RELEASE */

#define MAXSLSNAME  10
