%{
/* SccsId = "@(#)cmd_l.l 4.15 (TU-Delft) 04/13/95" */
/**********************************************************

Name/Version      : simeye/4.15

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.J. van Genderen
Creation date     : 29-May-1990
Modified by       : S. de Graaf
Modification date : 16-Aug-1993


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1990 , All rights reserved
**********************************************************/

#ifdef FLEX_SCANNER /* use GNU flex in stead of standard lex */
int yylineno = 1;
#define YYINCR(_count) yylineno += _count /* do it yourself */
#else
#define YYINCR(_x)             /* lex already keeps the line count */
#endif

%}
E		[DEde][-+]?[0-9]+
%%
"/*"			{
			int thechar;

			loop:
			    while ((thechar = input()) != '*') {
				if (thechar == 'n'
				    && (thechar = input ()) == 'o'
				    && (thechar = input ()) == '_'
				    && (thechar = input ()) == 'e'
				    && (thechar = input ()) == 'd'
				    && (thechar = input ()) == 'i'
				    && (thechar = input ()) == 't')
				    no_edit = 1;
				if (thechar == EOF || thechar == 0) return (0);
				if (thechar == '\n') YYINCR (1);
			    }
			    switch (input()) {
				case EOF :
				case 0 : return (0);
				case '/' : break;
				case '*' : unput ('*'); goto loop;
				case '\n': YYINCR (1);
				default : goto loop;
			    }
			}
"set"			{ no_edit = 0; return (SET); }
"l"			{ yylval.ival = L_state; return (LOGIC_LEVEL); }
"h"			{ yylval.ival = H_state; return (LOGIC_LEVEL); }
"x"			{ yylval.ival = X_state; return (LOGIC_LEVEL); }
"f"			{ yylval.ival = Free_state; return (LOGIC_LEVEL); }
"~"			{ return (TILDE); }
"from"			{ return (FROM); }
"fill"			{ return (FILL); }
"with"			{ return (WITH); }
"print"			{ return (PRINT); }
"plot"			{ return (PLOT); }
"option"		{ return (OPTION); }
"simperiod"		{ return (SIMPERIOD); }
"disperiod"		{ return (DISPERIOD); }
"dissipation"		{ return (DISSIPATION); }
"level"			{ return (LEVEL); }
"dump"			{ return (DUMP); }
"at"			{ return (AT); }
"initialize"		{ return (INITIALIZE); }
"sigoffset"		{ return (SIGOFFSET); }
"races"			{ return (RACES); }
"devices"		{ return (DEVICES); }
"statistics"		{ return (STATISTICS); }
"only"			{ return (ONLY); }
"changes"		{ return (CHANGES); }
"process"		{ return (SLS_PROCESS); }
"sigunit"		{ return (SIGUNIT); }
"outunit"		{ return (OUTUNIT); }
"outacc"		{ return (OUTACC); }
"maxpagewidth" 		{ return (MAXPAGEWIDTH); }
"maxnvicin"		{ return (MAXNVICIN); }
"maxtvicin"		{ return (MAXTVICIN); }
"maxldepth"		{ return (MAXLDEPTH); }
"vh"			{ return (VH); }
"vmaxl"			{ return (VMAXL); }
"vminh"			{ return (VMINH); }
"tdevmin"		{ return (TDEVMIN); }
"tdevmax"		{ return (TDEVMAX); }
"on"			{ yylval.ival = TRUE; return (TOGGLE); }
"off"			{ yylval.ival = FALSE; return (TOGGLE); }
"step"			{ return (STEP); }
"random"		{ return (RANDOM); }
"full"			{ return (FULL); }
"define"                { return (DEFINE_TOKEN); }
"sta_file"		{ return (STA_FILE); }
"."			{ return (DOT); }
".."			{ return (DOTDOT); }
"("			{ return (LPS); }
")"			{ return (RPS); }
"["			{ return (LSB); }
"]"			{ return (RSB); }
"{"			{ return (LCB); }
"}"			{ return (RCB); }
"="			{ return (EQL); }
","			{ return (COMMA); }
";"			{ return (SEMICOLON); }
":"			{ return (COLON); }
"*"			{ return (MULT); }
"!"			{ return (EXCLAM); }
"-"                     { return (MINUS); }
"$"                     { return (DOLLAR); }
\"[^"]*\"		{
			yytext[yyleng-1] = '\0';
			yylval.sval = yytext + 1;
			return (STRING);
			}
[a-zA-Z_][a-zA-Z0-9_]*	{ yylval.sval = yytext; return (IDENTIFIER); }
[0-9]+			{ yylval.sval = yytext; return (INT); }
[1][0]*[fpnumkMG]?   	{ double slstof ();
			  yylval.dval = slstof (yytext);
			  return (POWER_TEN);
			}
[0-9]+("."[0-9]+)?({E})?[fpnumkMG]?	{
			  double slstof ();
			  yylval.dval = slstof (yytext);
			  return (F_FLO);
			}
[\t ]+			;
"\\"[\n]		{ YYINCR(1); }
[\n]+			{ YYINCR(yyleng); return (NEWLINE); }

