static char *SccsId = "@(#)main_bs.c 3.3 (TU-Delft) 06/26/91";
/**********************************************************

Name/Version      : nspice/3.3

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.J. van Genderen
Creation date     : 8-June-1990
Modified by       :
Modification date :


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1990 , All rights reserved
**********************************************************/
#include <stdio.h>

#include "define.h"
#include "type.h"
#include "extern.h"

char *argv0 = "nspice_bs";
char *Usg_msg = "\nUsage: %s cell\n\n";

struct signal *Begin_signal = NULL;
struct signal *End_signal = NULL;
int Nr_signals;

long Endtime;
double Timescaling;
double outaccur;

struct node_ref *Begin_print = NULL;
struct node_ref *End_print = NULL;

int optGnd = 0;
int optVss = 0;
char node0[64];

char * cellname;

main (argc, argv)
int argc;
char **argv;
{
    char *s;

    cellname = NULL;

    while (--argc > 0) {
        if ( (*++argv)[0] == '-' ) {
	    for (s = *argv + 1; *s != '\0'; s++) {
	        switch (*s) {

		    default: 
		        fprintf (stderr, 
				 "%s: illegal option: %c\n", argv0, *s);
			fprintf (stderr, Usg_msg, argv0); 
		        exit (1);
	        }
	    }
	}
	else if (cellname == NULL) {
	    cellname = *argv;
	}
	else {
	    fprintf (stderr, Usg_msg, argv0); 
	    exit (1);
	}
    }

    if (cellname == NULL) {
	fprintf (stderr, Usg_msg, argv0); 
	exit (1);
    }

    readCir (cellname);

    backsubSpc (cellname);

    return (0);
}

backsubSpc (name)
char *name;
{
    char str1[512];
    char str2[512];

    char tmp[32];
    char help[48];
    int i;
    char *filename1;
    char *filename2;
    FILE *fp1;
    FILE *fp2;
    char buf[264];
    int match;
    char c;
    int found;
    int plot_tran;
    int nodenr;
    struct node_ref *tab;
    int errorFound;
    int spice3;


    sprintf (tmp, "%s", name);
    i = 0;
    while (tmp[i] != ' ' && tmp[i] != '\0') i++;
    tmp[i] = '\0';

    NEW (filename1, strlen (tmp) + 5, char);
    sprintf (filename1, "%s.ana", tmp);

    if ((fp1 = fopen (filename1, "r")) == NULL) {
	sprintf (help, "Cannot open %s", filename1);
	message (help);
	exit (1);
    }

    /* look for error messages and print them if any */

    errorFound = 0;
    while ((c = getc (fp1)) != EOF) {
        ungetc (c, fp1);
	if (c != ' ' && c != '\t' && c != '\n'
	    && fscanf (fp1, "%s", str1) == 1
	    && (str1[0] == '*')
	    && (str1[1] == 'E' || str1[1] == 'e')
	    && (str1[2] == 'R' || str1[1] == 'r')
	    && (str1[3] == 'R' || str1[1] == 'r')
	    && (str1[4] == 'O' || str1[1] == 'o')
	    && (str1[5] == 'R' || str1[1] == 'r')
	    && (str1[6] == '*')) {

            errorFound = 1;

	    fprintf (stderr, "spice: %s", str1);

	    while ((c = getc (fp1)) != '\n') {
		fputc (c, stderr);
	    }
	    fputc ('\n', stderr);
	}
	else {
	    while ((c = getc (fp1)) != '\n');
	}
    }
    rewind (fp1);

    if (errorFound) {
	exit (1);
    }

    NEW (filename2, strlen (tmp) + 5, char);
    sprintf (filename2, "%s.axa", tmp);

    if ((fp2 = fopen (filename2, "w")) == NULL) {
	sprintf (help, "Cannot open %s", filename2);
	message (help);
	exit (1);
    }

    while ((c = getc (fp1)) == ' ' || c == '\t' || c == '\n'
    || (c != EOF && !((c >= 'a' && c <= 'z') || (c >= 'A' && c <= 'Z')))) {
	putc (c, fp2);
    }
    ungetc (c, fp1);

    spice3 = -1;

    found = 0;
    while (1) {

	sprintf (str1, "");

	match = 0;
	while (!match && fscanf (fp1, "%s", str2) == 1) {

	    fprintf (fp2, str2);

	    if (spice3 == -1) {
                if (strcmp (str2, "Circuit:") == 0) {
                    spice3 = 1;     /* it is a spice3 ouput file */
                }
                else
                    spice3 = 0;     /* it is a spice2 ouput file */
            }

            if (spice3 == 0 &&
                ((strcmp (str1, "TRANSIENT") == 0
                 && strcmp (str2, "ANALYSIS") == 0)
                 || (strcmp (str1, "transient") == 0
                     && strcmp (str2, "analysis") == 0))) {
                match = 1;
            }

            if (spice3 == 1
                && strcmp (str1, "Index") == 0
                && strcmp (str2, "time") == 0) {
                match = 1;
            }

	    strcpy (str1, str2);

	    while ((c = getc (fp1)) == ' ' || c == '\t' || c == '\n'
	    || (c != EOF 
		&& !((c >= 'a' && c <= 'z') || (c >= 'A' && c <= 'Z')))) {
		putc (c, fp2);
	    }
	    ungetc (c, fp1);
	}

        if (spice3 == 0) {

	    plot_tran = 0;
	    match = 0;
	    while (!match && fscanf (fp1, "%s", str1) == 1) {

		fprintf (fp2, str1);

		if (strcmp (str1, "LEGEND:") == 0
		    || strcmp (str1, "legend:") == 0) {

		    plot_tran = 1;

		    while ((c = getc (fp1)) == ' ' || c == '\t' || c == '\n'
		    || (c != EOF 
		       && !((c >= 'a' && c <= 'z') 
                             || (c >= 'A' && c <= 'Z')))) {
			putc (c, fp2);
		    }
		    ungetc (c, fp1);

		    break;
		}

		if (strcmp (str1, "TIME") == 0
		    || strcmp (str1, "time") == 0) {
		    match = 1;
		}

		while ((c = getc (fp1)) == ' ' || c == '\t' || c == '\n'
		|| (c != EOF 
		    && !((c >= 'a' && c <= 'z') || (c >= 'A' && c <= 'Z')))) {
		    putc (c, fp2);
		}
		ungetc (c, fp1);
	    }

	    if (plot_tran)
		continue;
        }

	if (c == EOF)
	    break;

	while ((c = getc (fp1)) == ' ' || c == '\t')
	    putc (c, fp2);
	ungetc (c, fp1);

	if (c == EOF)
	    break;

        found = 1;

	while (c != '\n') {

	    fscanf (fp1, "%s", buf);

	    if ((buf[0] == 'v' || buf[0] == 'V') && buf[1] == '(') {

		if (sscanf (&buf[2], "%d", &nodenr) != 1) {
		    message ("read error for %s in file %s",
				   buf, filename1);
		    exit (1);
		}

		tab = Begin_table;
		while (tab && tab -> nodenr != nodenr) {
		    tab = tab -> next;
		}

		if (tab)
		    fprintf (fp2, "%s", tab -> name);
		else {
		    message ("Cannot find node %d in file %s.spc", 
				   nodenr, name);
		    exit (1);
		}
	    }
	    else {
		fprintf (fp2, buf);
	    }

	    while ((c = getc (fp1)) == ' ' || c == '\t') {
		putc (c, fp2);
	    }
	    ungetc (c, fp1);
	}

	while ((c = getc (fp1)) == ' ' || c == '\t' || c == '\n'
	|| (c != EOF && !((c >= 'a' && c <= 'z') || (c >= 'A' && c <= 'Z')))) {
	    putc (c, fp2);
	}
	ungetc (c, fp1);
    }

    if (!found)  {
	sprintf (help, "Cannot find transient analysis in %s", filename1);
	message (help);
	exit (1);
    }

    fclose (fp1);
    fclose (fp2);

    sprintf (buf, "mv %s %s", filename2, filename1);
    system (buf);
}

message (s, a1, a2, a3, a4, a5)
char *s;
char *a1, *a2, *a3, *a4, *a5;
{
    fprintf (stderr, "%s: ", argv0);
    fprintf (stderr, s, a1, a2, a3, a4, a5);
    fprintf (stderr, "\n");
}
