static char *SccsId = "@(#)sel_edge.c 4.2 (TU-Delft) 06/18/90";
/**********************************************************

Name/Version      : NBOOL/4.2

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : J. Annevelink
Creation date     : 31-Jan-1985
Modified by       : S. de Graaf
Modification date : 09-Dec-1985


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1985 , All rights reserved
**********************************************************/
#include "nbool.h"

#define cur_edge edges[edge_heap[0]]

/*
** select next edge from the vertical line segment file
*/
select_edge (pos_p, yb_p, yt_p, edge_type_p, chk_type_p, mask_p)
int    *pos_p,		/* position of new edge 	 */
       *yb_p,		/* bottom ordinate of new edge 	 */
       *yt_p,		/* top ordinate of new edge 	 */
       *chk_type_p;	/* check_type of new edge 	 */
unsigned   *mask_p;	/* mask code of new edge 	 */
char   *edge_type_p;	/* occurence type of new edge 	 */
{
    if (nf <= 0) return (NULL);

    /* assign attributes of edge to formal parameters */
    *pos_p       = cur_edge.pos;
    *yb_p        = cur_edge.yb;
    *yt_p        = cur_edge.yt;
    *edge_type_p = cur_edge.edge_type;
    *chk_type_p  = cur_edge.chk_type;
    *mask_p = cur_edge.mask;

    /* read new edge from line segment file */

    if (dmGetDesignData (cur_edge.fp, GEO_VLNLAY) > 0) {
	cur_edge.pos       = gvlnlay.x;
	cur_edge.yb        = gvlnlay.yb;
	cur_edge.yt        = gvlnlay.yt;
	cur_edge.edge_type = gvlnlay.occ_type;
	cur_edge.chk_type  = gvlnlay.chk_type;
    }
    else {
	dmCloseStream (cur_edge.fp, COMPLETE);
	edge_heap[0] = edge_heap[--nf];
    }

    if (nf > 0) reheap ();

    return (1);
}
