static char *SccsId = "@(#)errexit.c 4.3 (TU-Delft) 03/03/92";
/**********************************************************

Name/Version      : makevln/4.3

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : S. de Graaf
Creation date     : 02-Jan-1984
Modified by       : S. de Graaf
Modification date : 11-Feb-1987


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1987 , All rights reserved
**********************************************************/
#include "incl.h"

extern char tmpvln[];
extern char tmpteq[];
extern char *argv0;
extern int  flag_v;
extern DM_PROJECT *project;

char *errlist[] = {
/* 0 */  "%s",
/* 1 */  "cannot open file: %s",
/* 2 */  "cannot create file: %s",
/* 3 */  "cannot allocate enough core",
/* 4 */  "interrupted due to signal: %s",
/* 5 */  "error in ddm interface function",
/* 6 */  "unknown error"
};

errexit (errno, s)
int     errno;
char   *s;
{
    int i;

    i = (errno < 0) ? -errno : errno;
    if (i > 6) i = 6;

    fprintf (stderr, "%s: ", argv0);
    fprintf (stderr, errlist[i], s);
    fprintf (stderr, "\n");

    if (errno >= 0) die (1);
}

dmError (s)
char *s;
{
    fprintf (stderr, "%s: ", argv0);
    dmPerror (s);
    errexit (5, "");
}

die (status)
int  status;
{
    unlink (tmpvln);
    unlink (tmpteq);

    if (project) {
	if (status) {
	    dmCloseProject (project, QUIT);
	}
	else {
	    dmCloseProject (project, COMPLETE);
	}
    }
    dmQuit ();

    if (status) {
	fprintf (stderr,
	    "%s: -- program aborted --\n", argv0);
    }
    else if (flag_v) {
	fprintf (stderr,
	    "%s: -- program finished --\n", argv0);
    }
    exit (status);
}
