static char *SccsId = "@(#)convert.c 4.1 (TU-Delft) 05/24/90";
/**********************************************************

Name/Version      : makevln/4.1

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : J. Annevelink
Creation date     : 18-May-1983
Modified by       : S. de Graaf
Modification date : 29-Jan-1987


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1987 , All rights reserved
**********************************************************/
#include "incl.h"

extern struct event_rec *events;

struct event_rec *act_event;
struct sr_field head_sr, *h_sr;
long    sr_pos;

/*
** convert the boxes in the sorted event_list to line segments
*/
convert (max_event_no)
long    max_event_no;
{
    long    next_stop_pos;
    struct sr_field *r_sr;
    struct event_rec *max_event;

    act_event = events;
    max_event = &events[max_event_no];
    sr_pos = act_event -> xl;
    next_stop_pos = MAX_INTEGER;

    h_sr = &head_sr;
    h_sr -> next = h_sr -> prev = h_sr;
    h_sr -> yt = MIN_INTEGER;
    h_sr -> yb = MAX_INTEGER;
    r_sr = h_sr;

    while (act_event < max_event) {
	if (sr_pos != act_event -> xl) {
	    /* generate occurences */
	    do {
		next_stop_pos = MAX_INTEGER;
		ScanProf (&next_stop_pos);
	    }
	    while ((sr_pos = next_stop_pos) < act_event -> xl);
	    sr_pos = act_event -> xl;
	    r_sr = h_sr -> next;
	}
	insert_event (&r_sr, &next_stop_pos);
	++act_event;
    }

    /* generate final stop occurences */
    do {
	next_stop_pos = MAX_INTEGER;
	ScanProf (&next_stop_pos);
    }
    while ((sr_pos = next_stop_pos) < MAX_INTEGER);
}
