static char *SccsId = "@(#)expbox.c 4.1 (TU-Delft) 05/24/90";
/**********************************************************

Name/Version      : makebox/4.1

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : S. de Graaf
Creation date     : 22-Apr-1986
Modified by       : S. de Graaf
Modification date : 11-Dec-1987


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1987 , All rights reserved
**********************************************************/
#include "extern.h"

/*
** expand box/terminal to the root level
** of the mc-tree according to mc-parameters
*/
exp_box (Xl, Xr, Yb, Yt)
long Xl, Xr, Yb, Yt;
{
    register long *m;
    register struct tmtx *tm;
    long xl, xr, yb, yt, tmp;

    for (tm = tm_p; tm; tm = tm -> tm_next) {

	m = tm -> mtx;
	xl = m[0] * Xl + m[1] * Yb + m[2];
	yb = m[3] * Xl + m[4] * Yb + m[5];
	xr = m[0] * Xr + m[1] * Yt + m[2];
	yt = m[3] * Xr + m[4] * Yt + m[5];

	if (xl > xr) { tmp = xl; xl = xr; xr = tmp; }
	if (yb > yt) { tmp = yb; yb = yt; yt = tmp; }

	if (part_exp) {
	    if (xr <= exp_reg[0] || xl >= exp_reg[1]
	    ||  yt <= exp_reg[2] || yb >= exp_reg[3]) {
	    /*
	    ** the box-coordinates have no overlap
	    ** with the expansion region
	    */
		if (t_mask_no) ++term_no;
		continue;
	    }
	}

	gboxlay.xl = xl;
	gboxlay.xr = xr;
	gboxlay.yb = yb;
	gboxlay.yt = yt;
	gboxlay.chk_type = 0;
	dmPutDesignData (fp_bxx[mask_no], GEO_BOXLAY);
	++no_bxx[mask_no];

	if (t_mask_no) {
	    gboxlay.chk_type = term_no++;
	    dmPutDesignData (fp_bxx[t_mask_no], GEO_BOXLAY);
	    ++no_bxx[t_mask_no];
	}
    }
}
