static char *SccsId = "@(#)ITOTC.c 4.1 (TU-Delft) 05/24/90";
/**********************************************************

Name/Version      : libfunc/4.1

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : GOULD

Author(s)         : O. Hol
Creation date     : 18-Feb-1988
Modified by       : 
Modification date : 


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1988 , All rights reserved
**********************************************************/
#include <stdio.h>

char * adm_bsalloc();

/* ITOTC()  : converts an integer into a p-bits long bit string           */
/*          : using the two's complement representation                   */
/*          : a warning is given when integer is too 'big' for bit string */

char * ITOTC (i, p)
int i;
int p;
{
    char * s;
    int n;
    int w;

    s = adm_bsalloc ( p + 1, 'p' );

    if ( i < -(1 << (p-1)) || i > ( (1 << (p-1)) -1 ) ) {
        fprintf (stderr, "WARNING : ITOTC: integer %d too big for %d bits\n",i,p);
    }

    if ( i>=0 ) {
    	for (n = 0, w = 1; n < p-1 ; n++, w *= 2) {
            if (i % (2 * w) > 0) {
            	s[p-n-1] = 'I';
            	i -= w;
            }
            else {
            	s[p-n-1] = 'O';
            }
	}
        s[0] = 'O';
    }
    else {
	i = -(i+1);
    	for (n = 0, w = 1; n < p-1 ; n++, w *= 2) {
            if (i % (2 * w) > 0) {
            	s[p-n-1] = 'O';
            	i -= w;
            }
            else {
            	s[p-n-1] = 'I';
            }
	}
        s[0] = 'I';
    }

    s[p] = '\0';
    return(s);
}

