static char *SccsId = "@(#)dmrun.c 3.6 (TU-Delft) 03/26/91";
/**********************************************************

Name/Version      : The Design Data Management Project

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000/S500

Author(s)         : S. de Graaf
                    A. van der Hoeven
                    T.G.R. van Leuken
                    N. van der Meijs
		    T. Vogel
		    P. van der Wolf
Creation date     : 04-Dec-1986
Modified by       : S. de Graaf
Modification date : 11-Mar-1987


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1985-1987 , All rights reserved
**********************************************************/
#include "dmstd.h"
#  ifdef __STDC__
# include <stdarg.h>
#  else /* not __STDC__ */
# include <varargs.h>
#  endif /* else not __STDC__ */

#ifndef MSDOS
/*
** Return codes of fork
*/
#define CHILD 0
#define PARENT 1:default
#define ERROR -1 

/* 
** This function runs a subprogram with the given
** arguments.  These arguments must be of type "char *",
** the last must be NULL.
** See the example in the test driver.
** No system shells are started.
*/

/*VARARGS1*/
#  ifdef __STDC__
_dmRun ( char   *path, ...)
#  else /* not __STDC__ */
_dmRun (path, va_alist)
char   *path;
va_dcl
#  endif /* else not __STDC__ */
{
    va_list ap;
    int     status;
    int     argno = 0;
    char   *argv[64];

    argv[argno++] = path;

#  ifdef __STDC__
    va_start (ap, path);
#  else /* not __STDC__ */
    va_start (ap);
#  endif /* else not __STDC__ */
    while (argv[argno++] = va_arg (ap, char *)) {
	if (argno == 64)
	     _dmFatal ("_dmRun", "too many arguments", NULL);
    }
    va_end (ap);

    switch (fork ()) {
	case PARENT: 
	    (void) wait (&status);
	    break;
	case CHILD: 
	    execv (path, argv);
	    (void) fprintf (stderr, "_dmRun: ");
	    perror (path);
	    _exit (1);
	    break;
	case ERROR: 
	/* 
	 _dmFatal ("_dmRun", "can't fork", NULL);
	 */
	    perror ("_dmRun");
	    exit (1);
	    break;
    }
    return (status);
}

#ifdef DRIVER
main ()
{
    _dmRun ("/bin/echo", "a", "b", "c", "d", NULL);
}
#endif /* DRIVER */
#endif /* MSDOS */
