static char *SccsId = "@(#)dmprkey.c 3.12 (TU-Delft) 03/26/91";
/**********************************************************

Name/Version      : The Design Data Management Project

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000/S500

Author(s)         : S. de Graaf
                    A. van der Hoeven
                    T.G.R. van Leuken
                    N. van der Meijs
		    T. Vogel
		    P. van der Wolf
Creation date     : 04-Dec-1986
Modified by       : S. de Graaf
Modification date : 21-Jan-1988


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1985-1988 , All rights reserved
**********************************************************/

#include "dmstd.h"

static  DM_PROJECT * project_admin[DM_MAXPROJECTS];
static  projectno = -1;

/* 
** This function allocates a structure describing an
** project which is passed to the user and initializes it.
** Information must still be written to this structure.		 
*/
DM_PROJECT * _dmMk_projectkey ()
{
    DM_PROJECT * key;

    if (++projectno == DM_MAXPROJECTS) {
	_dmFatal ("_dmMk_projectkey: too many open projects", "", "");
    }

    if ((key = (DM_PROJECT *) malloc (sizeof (DM_PROJECT))) == NULL) {
	_dmFatal ("_dmMk_projectkey: cannot alloc key", "", "");
    }

    project_admin[projectno] = key;
    key -> projectno = projectno;

    return (key);
}

/* 
** This function removes the structure which is passed to
** the user at dmOpenProject time and which identifies the
** project opened.
*/
_dmRm_projectkey (key)
DM_PROJECT * key;
{
    if (key -> projectno != projectno) {
	project_admin[key -> projectno] = project_admin[projectno];
	project_admin[projectno] -> projectno = key -> projectno;
    }
    --projectno;
    _dmStrFree (key -> netpath);
    dmFree ((char *) key, sizeof(DM_PROJECT));
}

/* 
** check if some project is already opened
*/
_dmCh_opproj ()
{
    if (projectno == -1) return (0);
    return (1);
}

/* 
** check if project key is valid
*/
_dmCh_project (key)
DM_PROJECT * key;
{
    if (key == NULL
	    || projectno < 0
	    || project_admin[key -> projectno] != key) {
	dmerrno = DME_BADKEY;
	return (-1);
    }
    return (0);
}

DM_PROJECT * _dmCh_proj (path)
char *path;
{
    register int i;

    for (i = 0; i <= projectno; ++i) {
	if (strcmp (project_admin[i] -> netpath, path) == 0) {
	    return (project_admin[i]);
	}
    }
    return (NULL);
}

_dmClose_allproj (mode)
int mode;
{
    register int i;

    dmCkinAll (mode);
    for (i = projectno; i >= 0; --i)
	dmCloseProject (project_admin[i], mode);
}

/*
** _dmSearchProcInProjKeys () consults the project administration that
** is maintained in this source file, to see whether a project key
** exists with the same processid and the maskdata attached to it.
*/
DM_PROCDATA * _dmSearchProcInProjKeys (processid)
int processid;
{
    register int i;

    for (i = 0; i <= projectno; ++i) {
	if (project_admin[i] != NULL &&
		project_admin[i] -> procid == processid &&
		project_admin[i] -> maskdata != NULL)
	    return (project_admin[i] -> maskdata);
    }
    return (NULL);
}
