/*
 * In this file we define an interface to the memory allocation functions.
 * Without any call to dmMemoryOptions() memory is always managed by the
 * standard functions malloc() and free(). However, if a tool calls
 * dmMemoryOptions(DM_NEW_ALLOC | ...) before opening the nelsis database,
 * memory is managed by mnew() and mfree().
 *
 */


#include "dmstd.h"

/* these things are #define'd in dmmem.h but here we need the real thing! */
#undef malloc
#undef calloc
#undef free

#include <malloc.h>

/* the default memory options are: use traditional malloc and strSave */
int dm_mem_options = 0;

/* set new memory options, return the previous options: */
int dmMemoryOptions(options)
   int options;
{
   int oldoptions = dm_mem_options;
   if ((options & ~(DM_NEW_MALLOC | DM_NEW_STRINGSAVE)) != 0)
   {
      dmError("illegal args for dmMemoryOptions");
   }
   dm_mem_options = options;
   return oldoptions;
}


/* Depending on dm_mem_options, allocate a block of memory of size SIZ
 * either with malloc() or with mnew().
 */
char *dmNew(siz)
   int siz;
{
   if (dm_mem_options & DM_NEW_MALLOC)
      return mnew(siz);
   else
      return (char *)malloc(siz);
}


/* Depending on dm_mem_options, delete a block of memory of size SIZ
 * either with free() or with mfree().
 */
void dmFree(ptr, siz)
   void *ptr;
   int  siz;
{
   if (dm_mem_options & DM_NEW_MALLOC)
   {
      if (siz != DM_UNKNOWN_SIZE) /* do nothing if we don't know the SIZ */
	 mfree((char **)ptr, siz);
   }
   else
      free(ptr);
}
