static char *SccsId = "@(#)dmisroot.c 3.7 (TU-Delft) 03/26/91";
/**********************************************************

Name/Version      : The Design Data Management Project

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000/S500

Author(s)         : G.W. Sloof
		    P. van der Wolf
Creation date     : 31-Mar-1988
Modified by       : G.W. Sloof
Modification date : 05-Apr-1988
Modified by       : S. de Graaf
Modification date : 08-Apr-1988
Modification date : 25-Apr-1988


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1985-1988, All rights reserved
**********************************************************/
#include "dmstd.h"

/*
** _dmCellIsRoot checks if a cell with name 'cellname' and with
** viewtype 'view', being an element in 'dmproject', is a
** root-cell. Therefor it reads all mc_files belonging to cells
** in 'celllist_array'.
** If cellname exists in a mc_file : no root -> return (0)
** else cell with name 'cellname' is root -> return (1)
** Hard error: return (-1)
*/
_dmCellIsRoot (dmproject, cellname, viewtype)
DM_PROJECT * dmproject;
char   *cellname;
char   *viewtype;
{
    register int i;
    int     cell_is_root = -1;
    int     nr_cells_inlist;
    FILE   *celllist_fp;
    char   *celllist_array[DM_MAXCELLS + 1];
    char    celllist_member[DM_MAXNAME + 1];
    char    path[MAXLINE];

#ifdef DM_DEBUG
    IFDEBUG {
	fprintf (stderr, "_dmCellIsRoot: cell: %s, view: %s\n",
		cellname, viewtype);
    }
#endif /* DM_DEBUG */

    if (_dmCh_project (dmproject) != 0) {
	dmError ("_dmCellIsRoot: project key");
	return (-1);
    }

    /* read celllist and fill celllist_array with cellnames */
    _dmSprintf (path, "%s/%s/celllist", dmproject -> dmpath, viewtype);

    if (!(celllist_fp = fopen (path, "r"))) {
	dmerrno = DME_NOCELLL;
	dmError2 ("_dmCellIsRoot", path);
	return (-1);
    }

    i = 0;
    while (fscanf (celllist_fp, "%s", celllist_member) != EOF) {
	if (i == DM_MAXCELLS) {
	    dmerrno = DME_CORE;
	    dmError ("_dmCellIsRoot: too many cells in celllist");
	    nr_cells_inlist = i;
	    goto err_ret;
	}
	celllist_array[i++] = _dmStrSave (celllist_member);
    }
    nr_cells_inlist = i;
    celllist_array[i] = NULL;

    fclose (celllist_fp);

    cell_is_root = _dmCellIsRoot2 (dmproject,
			cellname, viewtype, celllist_array);

err_ret:
    for (i = 0; i < nr_cells_inlist; ++i) {
	_dmStrFree (celllist_array[i]);
    }
    return (cell_is_root);
}

_dmCellIsRoot2 (dmproject, cellname, viewtype, celllist_array)
DM_PROJECT * dmproject;
char   *cellname;
char   *viewtype;
char  **celllist_array;
{
    DM_STREAM  xxx;
    DM_STREAM *dsp = &xxx;
    int     found;
    int     fmt;
    char   *cell_name;
    char    path[MAXLINE];
    char    path2[MAXLINE];
    struct stat buf;
    register char **clp;

    if (strcmp (viewtype, CIRCUIT) == 0) {
	fmt = CIR_MC;
	cell_name = cmc.cell_name;
    }
    else if (strcmp (viewtype, LAYOUT) == 0) {
	fmt = GEO_MC;
	cell_name = gmc.cell_name;
    }
    else if (strcmp (viewtype, FLOORPLAN) == 0) {
	fmt = FLP_MC;
	cell_name = fmc.cell_name;
    }
    else {
	dmerrno = DME_BADVIEW;
	dmError ("_dmCellIsRoot");
	return (-1);
    }

    found = 0;

    for (clp = celllist_array; *clp != NULL; ++clp) {

	if (!found) {
	    if (strcmp (cellname, *clp) == 0) {
		++found;
		continue;
	    }
	}

	_dmSprintf (path, "%s/%s/%s/mc",
	    dmproject -> dmpath, viewtype, *clp);

	if (fmt == CIR_MC) {
	    if (stat (path, &buf) != 0) {
		/* cannot stat mc-file:
		** If circuit cell is function block,
		** no mc-file needs to exist.  (SdeG)
		*/
		_dmSprintf (path2, "%s/%s/%s/fterm",
		    dmproject -> dmpath, viewtype, *clp);
		if (stat (path2, &buf) == 0) {
		    /* ok, function block exists, skip this cell */
		    continue;
		}
	    }
	}

	if (!(dsp -> dmfp = fopen (path, "r"))) {
	    dmerrno = DME_FOPEN;
	    dmError2 ("_dmCellIsRoot", path);
	    return (-1);
	}

	while (dmGetDesignData (dsp, fmt) > 0) {
	    if (strcmp (cellname, cell_name) == 0) {
		fclose (dsp -> dmfp);
		return (0); /* no root */
	    }
	}

	fclose (dsp -> dmfp);
    }

    if (!found) {
	dmerrno = DME_NOCELL;
	dmError2 ("_dmCellIsRoot", cellname);
	return (-1);
    }

    return (1); /* cell is root */
}
