static char *SccsId = "@(#)dminit.c 3.23 (TU-Delft) 04/28/93";
/**********************************************************

Name/Version      : The Design Data Management Project

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000/S500

Author(s)         : S. de Graaf
                    A. van der Hoeven
                    T.G.R. van Leuken
                    N. van der Meijs
		    T. Vogel
		    P. van der Wolf
Creation date     : 04-Dec-1986
Modified by       : S. de Graaf
Modification date : 06-Jan-1988


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1985-1988 , All rights reserved
**********************************************************/

#include "dmstd.h"
#include "dmglobal.h"
#ifndef MSDOS
#include <pwd.h>
#include <sys/time.h>
#endif
#ifdef MSDOS
#include <time.h>
#endif

#define JAN 0
#define FEB 1
#define MAR 2
#define APR 3
#define MAY 4
#define JUN 5
#define JUL 6
#define AUG 7
#define SEP 8
#define OCT 9
#define NOV 10
#define DEC 11

#define YEAR 91

int     dmInit_flag = 0;
char   *dmToolname;

dmInit (progname)
char   *progname;
{
    char   *getenv ();
    char   *name;
    char   *path;
    char    str1[MAXLINE],
            str2[MAXLINE];
    int     i;
    int     t;
#ifndef MSDOS
    char   *gecos;
    struct passwd  *pw;
#endif
    struct tm  *tm;
#ifdef EXPDATE
    int     expdate = EXPDATE;
#endif				/* EXPDATE */
    int     year,
            month;
    extern int  dmhostnameprefix;
    extern char dmnethost[];

    if (dmInit_flag) {
	dmerrno = DME_INIT;
	dmError ("dmInit");
	return (-1);
    }

 /* Here we check if the user still has any rights to run */
#ifdef EXPDATE
    time (&t);
    tm = localtime (&t);

    year = expdate / 100;
    month = expdate - (year * 100) - 2;

    if ((tm -> tm_year < YEAR)
	    || (tm -> tm_year == YEAR && tm -> tm_mon < FEB)
	    || (tm -> tm_year > year)
	    || (tm -> tm_year == year && tm -> tm_mon > month)) {
	dmerrno = DME_DDM;
	dmError ("Your license has expired, contact your service organization.");
	exit (-1);
    }
#endif				/* EXPDATE */

 /* we now store progname in a global */
 /* in the future we might hand out	 */
 /* keys with progname in it. (PvdW). */
    dmToolname = _dmStrSave (progname);

#ifdef MSDOS
    if (!(name = getenv ("ICDUSERNAME"))) {
	name = "cacd";
    }
    if (!(path = getenv ("ICDPATH"))) {
	path = "/cacd";
    }
    strcpy (dmnethost, "A:");
#else
    if (!(name = getenv ("ICDUSERNAME"))) {
	name = ICDNAME;
    }
    pw = getpwnam (name);
    if (pw == 0) {
       fprintf (stderr, "The ICDUSERNAME '%s' does not occur in the passwd file\n", name);
       fprintf (stderr, "Please set your environment ICDUSERNAME correctly...\n", name);
       exit (1);
    }
    if (!(path = getenv ("ICDPATH"))) {
	path = pw -> pw_dir;
    }

 /* 
  the pw_gecos field in the password file has the following syntax:
  fullname,hostnameprefixflag,prefix
  
  i.e.: The Nelsis IC Design System,hostnameprefix,/nfs/
  */

    /*
     * This gecos stuff has been a nuisance for many years ...
     *
     *                !!!!! GET RID OF IT !!!!!!
     *
    gecos = pw -> pw_gecos;
    i = sscanf (gecos, "%*[^,],%[^,],%s", str1, str2);
    if (i != 2) {
	strcpy (str1, "nohostnameprefix");
	strcpy (str2, "/");
    }

    if (strcmp (str1, "hostnameprefix") == 0) {
	dmhostnameprefix = 1;
    }
    else
	if (strcmp (str1, "nohostnameprefix") == 0) {
	    dmhostnameprefix = 0;
	}
	else {
	    dmhostnameprefix = 1;
	}
#ifdef TUT
    dmhostnameprefix = 1;
    strcpy (str2, "//");
#endif
    *
    *
    */

#endif				/* MSDOS */
    dmhostnameprefix = 0;
    strcpy (dmnethost, "/");
    strcpy (icdpath, path);
    dmInit_flag = 1;
 /* 
  * Here we check if a user is authorized to use this tool according to ESE.
  * If not, the program will exit either with or without a message.
  */

#ifdef ESELICENSE
    eseVerifyLicense (progname);
#endif				/* ESELICENSE */
    return (0);
}

/* 
** dmQuit is called by _dmFatal and can be called by
** the application to check in all outstanding keys,
** to prevent locks remaining set
*/
dmQuit () {
#ifdef DM_DEBUG
    IFDEBUG
	fprintf (stderr, "dmQuit: dmInit_flag = %d\n", dmInit_flag);
#endif				/* DM_DEBUG */

    if (dmInit_flag) {
	dmInit_flag = 0;

	_dmClose_allproj (QUIT);
    }
    return (0);
}

#ifdef MSDOS
#ifdef ESELICENSE
int     eseLicenseChecked;

eseVerifyLicense (progname)
char   *progname;
{
    char   *getenv ();
    char   *esecodeword;
    int     i,
            len;
    char    code[9];

/* esedoesit */
    code[0] = 'e';
    code[1] = 's';
    code[2] = 'e';
    code[3] = 'd';
    code[4] = 'o';
    code[5] = 'e';
    code[6] = 's';
    code[7] = 'i';
    code[8] = 't';

    esecodeword = getenv ("ESECODEWORD");
    if (esecodeword == 0) {
	dmerrno = DME_DDM;
	dmError ("You did not set the ESECODEWORD, contact your service organization.");
	exit (-1);
    }
    len = strlen (esecodeword);
    for (i = 0; i < len; i++) {
	if (code[i] != esecodeword[i]) {
	    dmerrno = DME_DDM;
	    dmError ("You did not set the ESECODEWORD correctly, contact your service organization.");
	    exit (-1);
	}
    }
    eseLicenseChecked = 31;
    return 0;
}
#endif
#endif
