static char *SccsId = "@(#)dmexist.c 3.5 (TU-Delft) 03/26/91";
/**********************************************************

Name/Version      : The Design Data Management Project

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000/S500

Author(s)         : S. de Graaf
                    A. van der Hoeven
                    T.G.R. van Leuken
                    N. van der Meijs
		    T. Vogel
		    P. van der Wolf
Creation date     : 04-Dec-1986
Modified by       : 
Modification date : 


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1985-1987 , All rights reserved
**********************************************************/
#include "dmstd.h"

_dmExistCell (dmproject, cell, view)
DM_PROJECT * dmproject;
char   *cell,
       *view;
{
    struct stat stat_buf;
    char    path[MAXLINE];

    if (strlen (cell) > DM_MAXNAME) {	/* name too long; not accepted */
	dmerrno = DME_BADNAME;
	dmError (cell);
	return (-1);
    }
    if (dmTestname (cell))	/* dmTestname generates dmError () */
	return (-1);

    if (_dmValidView (view) == -1) {
	return (-1);
    }

    _dmSprintf (path, "%s/%s/%s",
	    dmproject -> dmpath, view, cell);
    if (stat (path, &stat_buf) == 0) {
	dmerrno = DME_EXIST;
	return (1);
    }

    dmerrno = DME_NOCELL;
    return (0);
}

_dmExistView (dmproject, view)
DM_PROJECT * dmproject;
char   *view;
{
    struct stat stat_buf;
    char    path[MAXLINE];

    if (_dmValidView (view) == -1) {
	return (-1);
    }

    _dmSprintf (path, "%s/%s",
	    dmproject -> dmpath, view);
    if (stat (path, &stat_buf) == 0) {
	dmerrno = DME_EXIST;
	return (1);
    }

    dmerrno = DME_NOVIEW;
    return (0);
}

_dmValidView (view)
char   *view;
{
    int view_entry;

    for (view_entry = 0; view_entry < DM_NOVIEWS; view_entry++) {
	if (strcmp (view, dmviews[view_entry]) == 0)
	    return (view_entry);
    }
    dmerrno = DME_BADVIEW;
    dmError (view);
    return (-1);
}
