static char *SccsId = "@(#)dmchkout.c 3.15 (TU-Delft) 03/26/91";
/**********************************************************

Name/Version      : The Design Data Management Project

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000/S500

Author(s)         : S. de Graaf
                    A. van der Hoeven
                    T.G.R. van Leuken
                    N. van der Meijs
		    T. Vogel
		    P. van der Wolf
Creation date     : 04-Dec-1986
Modified by       : S. de Graaf
Modification date : 21-Jan-1988


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1985-1988 , All rights reserved
**********************************************************/
#include "dmstd.h"

#ifdef ESELICENSE
/* check if ESE license software has been properly applied */
extern int  eseLicenseChecked;
#endif

/*
** This function 'checks_out' an existing cell of the
** current project.  The caller is returned a key which
** must be used when invoking the functions 'dmOpenStream' or
** 'dmCloseStream'.  These functions can then determine which
** object to access. 
** NULL is returned when the attempt fails.
*/

DM_CELL * dmCheckOut (dmproject, cell, versionstatus, versionnumber, view, mode)
DM_PROJECT * dmproject;
char   *cell,
       *versionstatus,
       *view;
int     versionnumber,
mode;
{
    DM_CELL * key;
    int     exist;
    char    path[MAXLINE];

#ifdef ESELICENSE
/* check if ESE license software has been properly applied */
    if (eseLicenseChecked != 31) {
	dmQuit ();
	exit (1);
    }
#endif

#ifdef DM_DEBUG
    IFDEBUG {
	fprintf (stderr, "cell: %s, version: %s, view: %s, mode: %d\n",
		cell, versionstatus, view, mode);
    }
#endif				/* DM_DEBUG */

    if (_dmCh_project (dmproject) != 0) {
	dmError ("project key");
	return (NULL);
    }

 /* Check existence of cell in view. ** The cellname and view are also
    tested. ** If exist == 0 cell doesnot exist, ** if exist == 1 cell
    does exist. */
    if ((exist = (int) dmGetMetaDesignData (EXISTCELL, dmproject, cell, view)) < 0) {
	return (NULL);
    }

 /* check if cell has already been checked out by this tool */
    if (_dmCh_cell (dmproject, cell, view)) {
	dmError (cell);
	return (NULL);
    }

    if (strcmp (versionstatus, ACTUAL))
	if (strcmp (versionstatus, WORKING))
	    if (strcmp (versionstatus, BACKUP))
		if (strcmp (versionstatus, DERIVED)) {
		    dmerrno = DME_BADARG;
		    dmError (versionstatus);
		    return (NULL);
		}

    if (!(mode == READONLY || mode == UPDATE || mode == ATTACH)) {
	dmerrno = DME_BADARG;
	dmError ("mode");
	return (NULL);
    }

    if (mode == UPDATE) {
	if (strcmp (versionstatus, WORKING))
	    if (strcmp (versionstatus, DERIVED)) {
		dmerrno = DME_BADARG;
		dmError ("mode");
		return (NULL);
	    }
    }

    if (!exist) {
	if (mode == READONLY || mode == ATTACH) {
	    dmerrno = DME_NOCELL;
	    dmError (cell);
	    return (NULL);
	}
	else {			/* mode == UPDATE */
	    _dmSprintf (path, "%s/%s/%s", dmproject -> dmpath, view, cell);
#if defined(OTHERCPU)
	    if (_dmRun ("/bin/mkdir", path, NULL)) {
		dmerrno = DME_SYS;
		dmError ("dmCheckOut");
		return (NULL);
	    }
#else
	    if (mkdir (path, 0777)) {
		dmerrno = DME_SYS;
		dmError ("dmCheckOut");
		return (NULL);
	    }
#endif
	    mode  |=CREATE;
	}
    }

    key = _dmMk_cellkey ();
    key -> dmproject = dmproject;
    key -> cell = _dmStrSave (cell);
    key -> versionstatus = _dmStrSave (versionstatus);
    key -> versionnumber = versionnumber;
    key -> view = _dmStrSave (view);
    key -> mode = mode;

#ifdef DM_DEBUG
    IFDEBUG {
	fprintf (stderr, "keyno: %d\n", key -> keyno);
	_dm_print_key (key, "dmCheckOut");
    }
#endif				/* DM_DEBUG */

 /* now inform the design (state) manager of the intention	 */
 /* to hand out a key for this cell. (PvdW).			 */
    if (_dmCOToDesMan (key) < 0) {
	dmError2 ("dmCheckOut", cell);
	return (NULL);
    }

    return (key);
}
