/* SccsId = "@(#)incl.h 4.3 (TU-Delft) 01/31/92" */
/*
 *      Copyright 1990 by Delft University of Technology (DUT),
 *                      Delft, The Netherlands.
 * 
 *                        All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and
 * its  documentation  without  fee,  is  hereby  granted  for  non-
 * commercial purposes  only,  provided  that  the  above  copyright
 * notice  appear  in all copies and that both that copyright notice
 * and this permission notice appear  in  supporting  documentation,
 * and  that the name of DUT not be used in advertising or publicity
 * pertaining to distribution  of  the  software  without  specific,
 * written prior permission.
 * 
 * THE DUT DISCLAIMS ALL WARRANTIES WITH REGARD  TO  THIS  SOFTWARE,
 * INCLUDING  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL THE DUT BE LIABLE FOR ANY SPECIAL, INDIRECT  OR
 * CONSEQUENTIAL  DAMAGES  OR  ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION  OF  CONTRACT,
 * NEGLIGENCE  OR  OTHER  TORTIOUS  ACTION,  ARISING  OUT  OF  OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 * 
 * Author(s):
 *           S. de Graaf
 *           T.G.R. van Leuken
 *           P. Kist
 * 
 * 
 * Contact address:
 * 
 * 
 * Dimes Design and Test Centre     phone: + 31 (15) 78 1459
 * Delft University of Technology   fax:   + 31 (15) 62 3271
 * P.O. Box 5053 		    email: nelsis@dutentb.tudelft.nl
 * Feldmannweg 17, 2600 GB Delft    The Netherlands
 */
#include "stdio.h"
#include "ctype.h"
#include "signal.h"
#include "sys/types.h"
#include "sys/time.h"
#include "sys/stat.h"
#include "dmincl.h"

struct mo_elmt {
    char    *mo;  /* cell name */
    DM_CELL *key; /* cell key */
    int      snr; /* symbolnr (CIF) */
    int      level;
    struct mo_elmt *next;
};

struct mc_elmt {
    struct mo_elmt *m;
    struct mc_elmt *c;
    struct mc_elmt *s;
};

struct ic_elmt {
    char  *mo;
    struct ic_elmt *l;
    struct ic_elmt *r;
};

struct na_elmt {
    char  *name;
    struct mo_elmt *m;
    struct na_elmt *other;
    struct na_elmt *next;
};

#define LDM 1
#define CIF 2
#define CMK 3
#define DLL 4

#define PE fprintf (stderr,
#define PF fprintf (fp_file,

#define ALLOC(ptr,type) {\
if (!(ptr = (type *) malloc (sizeof (type))))\
error (3, "type"); }

#define FREE(ptr) free((char *)(ptr))

#ifdef SYSV
#define  index strchr
#define rindex strrchr
#endif

char *ctime ();
char *dtoa ();
char *findnew ();
char *malloc ();
char *index ();
char *rindex ();
char *strcpy ();
char *strsave ();
struct na_elmt *findold ();

