
: SccsId = "@(#)outgds.sh 4.1 (TU-Delft) 06/09/90"
# 
# outgds - put a GDS II-file on tape
#
# created by   : R. Paulussen
# creation date: 08-Feb-1988
#
# A 1600 bpi non-rewind tape unit is used.
# 
USAGE="Usage: outgds maincell [volume]"

if test $# -gt 2
then
    echo ""
    echo "$USAGE"
    echo ""
    exit 1
fi

for dev in /dev/rmt12 /dev/rmt/0mn /dev/rmt/1mn no_dev
do
    if test -w $dev
    then break
    fi
done
if test $dev = no_dev
then
    echo "outgds: sorry: no writable tape device exist!"
    exit 1
fi

vol=1
if test $# -eq 2
then
    vol=$2
fi

if test $# -ge 1
then
    naam=$1
    echo "Putting on tape maincell: $naam"
    echo "Volume: $vol"
    echo "**** outgds starting ****"
    dd if=$naam'.gds.'$vol of=$dev bs=2048
    if test $? -ne 0
    then
	echo "outgds: tape write error"
	exit 1
    fi
    echo "**** outgds finished ****"
    echo "maincell $naam volume $vol on tape"
    if test $# -eq 2
    then
	echo "Mount new tape for a next volume, please"
	echo "and use outgds again"
    fi
    mt -t $dev rew
    mt -t $dev offl
else
    echo ""
    echo "$USAGE"
    echo ""
    exit 1
fi

exit 0
# end of script
