static char *SccsId = "@(#)clambda.c 4.1 (TU-Delft) 06/09/90";
/**********************************************************

Name/Version      : clambda/4.1

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000/500

Author(s)         : R. Paulussen
Creation date     : 02-Dec-1987
Modified by       : S. de Graaf
Modification date : 18-Mar-1988


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1988, All rights reserved
***********************************************************
MADE BY:
	Delft University of Technology
	Department of Submicron Technology
	Lorentzweg 1
	DELFT
	The Netherlands
***********************************************************
PROCESS DESCRIPTION:
	This program changes the old value of lambda
	into the specified value.
**********************************************************/
#include "stdio.h"

#define PE fprintf(stderr,
#define BL 20

char  buf1[BL];
char  buf2[BL];
char  buf3[BL];
char  buf4[BL];

char *argv0 = "clambda";	/* Program Name */

main (argc, argv)
int     argc;
char   *argv[];
{
    double  atof ();
    double  lambda;
    FILE   *fp_dmrc;

    if (argc != 2) {
	PE "\nUsage: %s lambda\n\n", argv0);
	exit (1);
    }

    lambda = atof (argv[1]);
    if (lambda < 0.001) {
	PE "%s: new value of lambda is too small (>= 0.001)\n", argv0);
	exit (1);
    }

    if ((fp_dmrc = fopen (".dmrc", "r")) == NULL) {
	PE "%s: current directory is no project\n", argv0);
	exit (1);
    }

    if (!fgets (buf1, BL, fp_dmrc)) goto read_err;
    if (!fgets (buf2, BL, fp_dmrc)) goto read_err;
    if (!fgets (buf3, BL, fp_dmrc)) goto read_err;
    if (!fgets (buf4, BL, fp_dmrc)) goto read_err;
    if (getc (fp_dmrc) != EOF) {
	PE "%s: more than four lines in file .dmrc\n", argv0);
	exit (1);
    }
    fclose (fp_dmrc);

    if ((fp_dmrc = fopen (".dmrc", "w")) == NULL) {
	PE "%s: cannot overwrite file .dmrc\n", argv0);
	exit (1);
    }

    printf ("%s: old value of lambda: %s", argv0, buf3);
    printf ("%s: new value of lambda: %.3f\n", argv0, lambda);

    fputs (buf1, fp_dmrc);
    fputs (buf2, fp_dmrc);
    fprintf (fp_dmrc, "%.3f\n", lambda);
    fputs (buf4, fp_dmrc);
    fclose (fp_dmrc);

    exit (0);

read_err:
    PE "%s: read error in file .dmrc\n", argv0);
    exit (1);
}
