static char *SccsId = "@(#)addfunob.c 4.4 (TU-Delft) 07/27/92";
/**********************************************************

Name/Version      : func_mkdb/4.4

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : GOULD

Author(s)         : O. Hol
Creation date     : 05-Nov-1987
Modified by       : S. de Graaf
Modification date : 25-Apr-1988
Modified by       : P.E. Menchen
Modification date : 06-Sep-1991


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1987-1991, All rights reserved
**********************************************************/
#include "func_parse.h"

extern DM_CELL *key;

/* Function addfun_obj()
** first compiles the created C-code and then places
** the object file, with the name 'sls.o' in the database.
*/
void    addfun_obj (fistr)
char    fistr[];
{
    char    arg_a[BUFSIZ];
#if NCF_RELEASE < 400
    char    arg_b[BUFSIZ];
#endif

    sprintf (arg_a, "%s.c", fistr);
    sprintf (cmdstr, "cc -c %s%s", C_options, arg_a);
    if (verbose) fprintf (stderr, "%s\n", cmdstr);
    if (system (cmdstr) != 0) {
	die (3, arg_a, ""); /* no successful compilation */
    }

    if (cflag == 0)
	rmexec (arg_a);

    sprintf (arg_a, "%s.o", fistr);

#if NCF_RELEASE < 400
    sprintf (arg_b, "circuit/%s/sls.o", Func_name);

    sprintf (cmdstr, "mv %s %s", arg_a, arg_b);
    if (verbose) fprintf (stderr, "%s\n", cmdstr);
    if (fork () == 0)
	execl ("/bin/mv", "mv", arg_a, arg_b, NULL);
    wait (NULL);
#else
    if (verbose) {
	fprintf (stderr,
		"Moving 'sls.o' into database for cell '%s'\n", Func_name);
    }
    dmMoveFileToStream (key, arg_a, "sls.o");
#endif
}

/* Function cppexec()
** executes 'cc -E' to get out the defines
*/
void    cppexec (cppin, cppout, cname)
char    cppin[], cppout[], cname[];
{
    struct stat statBuf;
    char    cmdstr[BUFSIZ];
    int manner;

    manner = 3;

#ifdef apollo
    manner = 2;
#endif
#ifdef sun
    manner = 2;
#endif
#ifdef hp9000s800
    manner = 3;
#endif

    switch (manner) {
	case 1:
	    sprintf (cmdstr, "cc -E %s%s > %s", C_options, cppin, cppout);
	    break;
	case 2:
	    if (stat ("/usr/lib/cpp", &statBuf) == 0)
		sprintf (cmdstr, "/usr/lib/cpp %s%s > %s", 
				 C_options, cppin, cppout);
	    else if (stat ("/lib/cpp", &statBuf) == 0)
		sprintf (cmdstr, "/lib/cpp %s%s > %s", 
				 C_options, cppin, cppout);
	    else if (stat ("/usr/bin/cpp", &statBuf) == 0)
		sprintf (cmdstr, "/usr/bin/cpp %s%s > %s", 
				 C_options, cppin, cppout);
	    break;
	case 3:
	    sprintf (cmdstr, "cp %s %s; cc -E %s%s > %s", 
			      cppin, cname, C_options, cname, cppout);
	    break;
    };

    if (verbose) fprintf (stderr, "%s\n", cmdstr);
    system (cmdstr);
}

/* Function rmexec() executes 'rm'
*/
void    rmexec (arg)
char    arg[];
{
    char    cmdstr[BUFSIZ];
    struct stat dummy;

    if (stat (arg, &dummy) == 0) {
	sprintf (cmdstr, "/bin/rm %s", arg);
	/*
	if (verbose) fprintf (stderr, "%s\n", cmdstr);
	*/
	if (fork () == 0)
	    execl ("/bin/rm", "rm", arg, NULL);
	wait (NULL);
    }
}
