static char *SccsId = "@(#)update_sr.c 4.1 (TU-Delft) 05/24/90";
/**********************************************************

Name/Version      : DUBCHECK/4.1

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : J. Liedorp
Creation date     : 24-Jun-1985
Modified by       : S. de Graaf
Modification date : 09-Dec-1985


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1985 , All rights reserved
**********************************************************/
#include "dubcheck.h"

update_sr (x_sr, xnew)
int     xnew;			/* next state_ruler pos. */
int     x_sr;			/* state_ruler position	 */
{
/* This procedure updates the state_ruler after it has	 */
/* been analysed by extr_profile or extr_overlap, and	 */
/* merges fields if possible.				 */

    register int    dx1;
    register int    dx2;
    register int    dx3;
    register int    dx_prev1;
    register int    dx_prev2;
    register int    dx_prev3;
    register struct sr_field   *c_sr;
    struct sr_field *rm_pntr;

/* update fields */

    dx_prev1 = MAXINFLUENCE;
    dx_prev2 = MAXINFLUENCE;
    c_sr = h_sr -> next;
    while (c_sr != h_sr) {
	if (c_sr -> lay_status[0] == CHG_TO_PRESENT) {
	    c_sr -> lay_status[0] = PRESENT;
	    c_sr -> xstart[0] = x_sr;
	}
	if (c_sr -> lay_status[0] == CHG_TO_NOTPRESENT) {
	    c_sr -> lay_status[0] = NOT_PRESENT;
	    c_sr -> xstart[0] = x_sr;
	}
	if (c_sr -> lay_status[1] == CHG_TO_PRESENT) {
	    c_sr -> lay_status[1] = PRESENT;
	    c_sr -> xstart[1] = x_sr;
	}
	if (c_sr -> lay_status[1] == CHG_TO_NOTPRESENT) {
	    c_sr -> lay_status[1] = NOT_PRESENT;
	    c_sr -> xstart[1] = x_sr;
	}
	if (c_sr -> helplay_status == CHG_TO_PRESENT) {
	    c_sr -> helplay_status = PRESENT;
	    c_sr -> helplay_xstart = x_sr;
	}
	if (c_sr -> helplay_status == CHG_TO_NOTPRESENT) {
	    c_sr -> helplay_status = NOT_PRESENT;
	    c_sr -> helplay_xstart = x_sr;
	}

/* merge fields */

	dx1 = MIN (xnew - c_sr -> xstart[0], MAXINFLUENCE);
	dx2 = MIN (xnew - c_sr -> xstart[1], MAXINFLUENCE);
	dx3 = MIN (xnew - c_sr -> helplay_xstart, MAXINFLUENCE);
	if ((dx_prev1 == dx1) && (dx_prev2 == dx2) && (dx_prev3 == dx3) &&
		(c_sr -> lay_status[0] == c_sr -> prev -> lay_status[0]) &&
		(c_sr -> lay_status[1] == c_sr -> prev -> lay_status[1]) &&
		(c_sr -> chk_type[0] == c_sr -> prev -> chk_type[0]) &&
		(c_sr -> chk_type[1] == c_sr -> prev -> chk_type[1]) &&
		(c_sr -> helplay_status == c_sr -> prev -> helplay_status)) {
	    c_sr -> prev -> yt = c_sr -> yt;
	    rm_pntr = c_sr;
	    c_sr -> prev -> next = c_sr -> next;
	    c_sr -> next -> prev = c_sr -> prev;
	    FREE (rm_pntr);
	    c_sr = c_sr -> prev;
	}
	dx_prev1 = dx1;
	dx_prev2 = dx2;
	dx_prev3 = dx3;
	c_sr = c_sr -> next;
    }
}
