static char *SccsId = "@(#)print_err.c 4.1 (TU-Delft) 05/24/90";
/**********************************************************

Name/Version      : DUBCHECK/4.1

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)	  : J. Liedorp
Creation date	  : 25-Nov-1985
Modified by       : J. Liedorp
Modification date : 02-Dec-1987


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1984 , All rights reserved
**********************************************************/
#include "dubcheck.h"

print_err (kind) {

/* This procedure prints the errors stored in the tempory*/
/* file bufil. It uses the procedure equiv_grp to suppres*/
/* errors between equivalent groups.			 */

    while (fread ((char *) & buff, sizeof (buff), 1, bufil) != 0) {
	if ((kind == 0) || (equiv_grp () == FALSE)) {
	    error_meas ("gap", buff.x1, buff.y1, buff.x2, buff.y2);
	    Errno++;
	}
    }
}

equiv_grp () {

/* This procedure looks if the group_numbers in the	 */
/* buffer are equivalent,i.e. if the groups overlap.	 */
/* If they do TRUE is returned; otherwise FALSE.	 */

    struct group   *g_pntr;
    struct eq  *eq_pntr;
    unsigned    mask = GRP_BUFLEN - 1;
    unsigned    i;
    unsigned    j;

    i = buff.group1 & mask;
    j = buff.group1 / GRP_BUFLEN;
    g_pntr = group_arr[j];
    if (g_pntr == NULL)
	return (FALSE);
    eq_pntr = g_pntr[i].eq_pntr;
    while (eq_pntr != NULL) {
	if (eq_pntr -> eq_group == buff.group2)
	    return (TRUE);
	eq_pntr = eq_pntr -> next;
    }
    return (FALSE);
}
