/* SccsId = "%Z%%M% %I% (%Q%) %G%" */
/**********************************************************

Name/Version      : sls_mkdb/%I%

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.C. de Graaf
Creation date     : 10-Jul-1986
Modified by       : S. de Graaf
Modification date : 10-Jul-1986
Modified by       : A.J. van Genderen
Modification date : Jan-1994 (converted to c++)


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1986,1994 All rights reserved
**********************************************************/
stack::stack (short size) {
    top = min = new char * [size];
    max = min + size;
    {
	char **help = min;
	while (help < max)
	    *help++ = NULL;
    }
#ifdef DMEM
    stack_nbyte += sizeof(class stack);
    stack_maxnbyte = stack_nbyte > stack_maxnbyte ? stack_nbyte:stack_maxnbyte;
#endif
}

stack::~stack() {
#ifdef DMEM
    stack_nbyte -= sizeof(class stack);
#endif
}

void stack::reset() {
    top = min;
}

int stack::empty() {
    return (top == min);
}

int stack::push(char *elem) {
    if(top < max) {
	*top++ = elem;
	return STACK_OK;
    }
    else
	return STACK_OVERFLOW;
}

char * stack::pop() {
    if(top > min)
	return (*--top);
    else
	return (STACK_UNDERFLOW);
}

void stack::print() {
	char **pxs;
	printf("StackB\n");
	printf("ptr: %x\tsize: %d\tmin: %x\t max: %x\ttop: %x\n",
		this, (top - min), min, max, top);
	for(pxs = min; pxs < top; pxs++)
	    printf("[%d] ptr: %x\t*ptr: %x\n",(pxs-min), pxs, *pxs);
	printf("StackE\n");
}

char *stack::access(int x) {
	if(!empty())
	{
	    if(x < 0 || x >= (top - min))
		fprintf(stderr,"stack: Invalid index");
	    else
		return (*(min+x));
	}

	return ((char *)NULL);
}

class stack *stack::copy() {
	class stack *pstack = 0;
	char **p;

	if(!empty())
	{
	    pstack = new class stack (top-min);
	    for(p = min; p < top; p++)
		pstack->push(*p);
	}
	return pstack;
}

char **stack::base() {
	return min;
}

char **stack::limit() {
	return max;
}

int stack::length() {
	return (top - min);
}
