%{
/* SccsId = "%Z%%M% %I% (%Q%) %G%" */
/**********************************************************

Name/Version      : sls_mkdb/%I%

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.J. van Genderen
Creation date     : 14-May-1992
Modified by       : 
Modification date :


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1986 , All rights reserved
**********************************************************/
#include "spipar.h"
#include "class.h"
#include "mkdbdefs.h"
#include "mkdbincl.h"

#ifdef __cplusplus
#define input yyinput
#endif

# if defined (sun)
extern "C" {
/*
extern int input ();
*/
extern int yywrap ();
extern int yylook ();
extern int yyback(int *, int);
}
# endif /* sun */

#define YY_DECL extern "C" int yylex(void)

#ifdef FLEX_SCANNER
int yylineno = 1;
#define YYINCR(_count) yylineno += _count /* have to do this ourselves ... */
#else
#define YYINCR(_x)
#endif

extern int behind_header;  /* used for setting initial condition:
			      only if behind_header = 1, a name starting
			      with a 'r' should be recognized as a resistor */
extern int toppresent;

%}

D	[0-9]
E	[DEde][-+]?{D}+

%START NL

%%
[*;]			{ 
			    int thechar;

			    while ((thechar = input()) != '\n') {
				if (thechar == EOF || thechar == 0) return(0);
			    }
			    unput ('\n');
			}
"#"[^\n]*\n             { YYINCR (1);
                          if (behind_header)
			      BEGIN NL;
			  parseLineStmt ((char *) yytext);
		        }
".subckt"		{ BEGIN 0; if (!toppresent) behind_header = 1; 
			  return(SUBCKT); }
".SUBCKT"		{ BEGIN 0; if (!toppresent) behind_header = 1; 
			  return(SUBCKT); }
".ends"			{ BEGIN 0; if (!toppresent) behind_header = 0; 
			  return(ENDS); }
".ENDS"			{ BEGIN 0; if (!toppresent) behind_header = 0; 
			  return(ENDS); }
".end"			{ BEGIN 0; return(END); }
".END"			{ BEGIN 0; return(END); }
".connect"		{ BEGIN 0; return(CNET); }
".CONNECT"		{ BEGIN 0; return(CNET); }
"."[a-zA-Z0-9_]*	{ BEGIN 0; return(OTHER_CARD_BEGIN); }
"."			{ BEGIN 0; return(PERIOD); }
"="			{ BEGIN 0; return(ASSIGN)  ; }
"("			{ BEGIN 0; return(LPS)     ; }
")"			{ BEGIN 0; return(RPS)     ; }
<NL>vnet[a-zA-Z0-9_]*	{ yylval.sval = (char *) yytext;
			  BEGIN 0; return(VNET); }
<NL>VNET[a-zA-Z0-9_]*	{ yylval.sval = (char *) yytext;
			  BEGIN 0; return(VNET); }
<NL>rnet[a-zA-Z0-9_]*	{ yylval.sval = (char *) yytext;
			  BEGIN 0; return(RNET); }
<NL>RNET[a-zA-Z0-9_]*	{ yylval.sval = (char *) yytext;
			  BEGIN 0; return(RNET); }
<NL>[mM][a-zA-Z0-9_]*	{ yylval.sval = (char *) yytext;
			  BEGIN 0; return(TOR_INST); }
<NL>[xXqQjJ][a-zA-Z0-9_]*	{ yylval.sval = (char *) yytext;
			  BEGIN 0; return(NETW_INST); }
<NL>[rR][a-zA-Z0-9_]*	{ yylval.sval = (char *) yytext;
			  BEGIN 0; return(RES_INST); }
<NL>[cC][a-zA-Z0-9_]*	{ yylval.sval = (char *) yytext;
			  BEGIN 0; return(CAP_INST); }
[wW]			{ yylval.sval = (char *) yytext;
			  BEGIN 0; return(T_WIDTH); }
[lL]			{ yylval.sval = (char *) yytext;
			  BEGIN 0; return(T_LENGTH); }
[a-zA-Z$_][a-zA-Z0-9$_]*	{ yylval.sval = (char *) yytext;
			  BEGIN 0; return(IDENTIFIER); }
"-"?{D}+		{ yylval.sval = (char *) yytext;
			  BEGIN 0; return(INTEGER); }
"-"?{D}+("."{D}+)?({E})?([a-zA-Z_]*)?	{ yylval.sval = (char *) yytext;
			  BEGIN 0; return(FLOAT); }
"\n+"                   { YYINCR (1); 
			  /* this is a line (card) continuation. */
			}  
[\t ]+			{ BEGIN 0; }
\n			{ if (behind_header) BEGIN NL; 
			  YYINCR (1);
			  return (NEWLINE); }
[^*^=^.^(^)^ ^\n^\t^+^-]+	{ BEGIN 0; return(OTHER); }

%%

int Input ()
{
    return (input ());
}

#ifdef MSDOS
int yywrap ()
{
    return (1);
}
#endif
