/* SccsId = "%Z%%M% %I% (%Q%) %G%" */
/**********************************************************

Name/Version      : sls_mkdb/%I%

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.C. de Graaf
Creation date     : 10-Jul-1986
Modified by       : S. de Graaf
Modification date : 10-Jul-1986
Modified by       : A.J. van Genderen
Modification date : Jan-1994 (converted to c++)


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1986,1994 All rights reserved
**********************************************************/

netelem::netelem (char *s, Stack *stack, char ntype) : lnk (ntype)
{
    name = (char *) strsav(s);
    strcpy(name, s);
    xs = stack;
    eqv = NULL;
    nmem = NULL;
    if (ntype == TermType)
	type = N_TERMINAL;
    else
	type = N_NET;
#ifdef DMEM
    netelem_nbyte += sizeof(class netelem);
    netelem_maxnbyte = netelem_nbyte > netelem_maxnbyte?
		    netelem_nbyte : netelem_maxnbyte;
#endif
}

netelem::~netelem () {
    delete name;
#ifdef DMEM
    char_nbyte -= strlen(name) + 1;
#endif
    if(lnk::type == NetType)
    {
        if(xs)
        {
	    stackfree(xs, XELEM);
            delete xs;
        }
    }
#ifdef DMEM
    netelem_nbyte -= sizeof(class netelem);
#endif
}

void netelem::print() {
    fprintf(stderr,"[ Netelem ] ptr = %x {\n",this);
    fprintf(stderr,"\tname =\t%s\n",name);
    fprintf(stderr,"\txs   =\t%x\n",xs);
    fprintf(stderr,"}\n");
}

void netelem::to_db() {
	char **pxs;
	int i;
	int size = xs ? xs -> limit() - xs->base() : 0;

	strcpy(cterm.term_name, name);
	cterm.term_dim = size;
#ifdef DMEM
    int_nbyte += size * sizeof(int);
    int_maxnbyte = int_nbyte > int_maxnbyte?
		    int_nbyte : int_maxnbyte;
#endif
	cterm.term_lower = new long [size];
#ifdef DMEM
    int_nbyte += size * sizeof(int);
    int_maxnbyte = int_nbyte > int_maxnbyte?
		    int_nbyte : int_maxnbyte;
#endif
	cterm.term_upper = new long [size];

	if(xs)
	{
	    /* lower _boundaries */
	    for(i=0, pxs=xs->base(); pxs < xs->limit(); i++, pxs++)
		cterm.term_lower[i] = ((Xelem *) *pxs)->left_bound;

	    /* upper _boundaries */
	    for(i=0, pxs=xs->base(); pxs < xs->limit(); i++, pxs++)
		cterm.term_upper[i] = ((Xelem *) *pxs)->right_bound;
	}

	dmPutDesignData(dsp_term, CIR_TERM);
 	if(cterm.term_dim)
	{
#ifdef DMEM
    int_nbyte -= size * sizeof(int);
#endif
	    delete cterm.term_lower;
#ifdef DMEM
    int_nbyte -= size * sizeof(int);
#endif
	    delete cterm.term_upper;
	}
}

net_ref::net_ref (class netelem *pnet, Stack *xs) : lnk (NetRefType)
{
    net = pnet;
    net_xs = xs;
    inst = NULL;
    inst_xs = NULL;
    ref_xs = NULL;
#ifdef DMEM
    net_ref_nbyte += sizeof(class net_ref);
    net_ref_maxnbyte = net_ref_nbyte > net_ref_maxnbyte?
		    net_ref_nbyte : net_ref_maxnbyte;
#endif
}

net_ref::~net_ref () {
#ifdef DMEM
    net_ref_nbyte -= sizeof(class net_ref);
#endif
    if(net_xs)
    {
/*
	if(((Link *) net)->type == NetType)
	    stackfree(net_xs, XELEM);
        delete net_xs;
*/
    }

    if(ref_xs)
    {
        delete ref_xs;
    }
}
