/* SccsId = "%Z%%M% %I% (%Q%) %G%" */
/**********************************************************

Name/Version      : sls_mkdb/%I%

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.C. de Graaf
Creation date     : 10-Jul-1986
Modified by       : S. de Graaf
Modification date : 10-Jul-1986
Modified by       : A.J. van Genderen
Modification date : Jan-1994 (converted to c++)


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1986,1994 All rights reserved
**********************************************************/
extern int doSimpleNet;
extern int genIntNet;
extern int externRequired;
extern int forbidFirstCapital;
extern int noWarnings;
extern int sls_errcnt;
extern int sls_errno;
extern int sls_nerr;
extern char *sls_errlist[];

extern int yylineno;
extern char fn_incl[];

extern int int_nbyte, int_maxnbyte;
extern int char_nbyte, char_maxnbyte;
extern int ntwdef_nbyte, ntwdef_maxnbyte;
extern int ntwinst_nbyte, ntwinst_maxnbyte;
extern int inst_struct_nbyte, inst_struct_maxnbyte;
extern int netelem_nbyte, netelem_maxnbyte;
extern int dict_nbyte, dict_maxnbyte;
extern int net_ref_nbyte, net_ref_maxnbyte;
extern int xelem_nbyte, xelem_maxnbyte;
extern int queue_nbyte, queue_maxnbyte;
extern int stack_nbyte, stack_maxnbyte;

# ifdef __cplusplus
  extern "C" {
# endif

/* bifunc.c */
void init_bifs P_((void));
Network *is_bifunc P_((char * name));

/* dbaccess.c */
datum *dbfetch P_((DbAcces *dbacces, datum *key));
int dbdelete P_((DbAcces *dbacces, datum *key));
int dbstore P_((DbAcces *dbacces, datum *key, datum *dat));
datum *firstkey P_((DbAcces *dbacces));
datum *nextkey P_((DbAcces *dbacces, datum *key));

/* dbopen.c */
DbAcces *dbOpen P_((char *dbname));
int dbClose P_((DbAcces **dbacces));

/* dffunc.c */
Network *read_dff P_((char *name));

/* diction.c */
#ifdef MSDOS
char *mktemp P_((char *filename));
#endif

/* end_ntw.c */
int end_ntw P_((Network *ntw, int ext, int orig_mode));

/* init_ntw.c */
Network *init_ntw P_((char *name, int ext));
Network *read_ntw P_((char *name));
int checkDbTerm P_((Netelem *term));
void finalCheckDbTerm P_((void));
int existCell P_((char *name, char *view));

/* lex.l */
int Input P_((void));
#if defined(sun)
int yylex P_((void));
#endif

/* main.c */
void die P_((void));
double cvt_atof P_((char *s));
char *isGlobalNet P_((char *s));
char *isDefGlobalNet P_((char *s));
void rcReadError P_((char *fn, char *s));
void parseLineStmt P_((char *s));

/* neteqv.c */
int chk_bounds P_((Stack * xs1, Stack * xs2));
void net_eqv P_((Queue * dst, Queue * src));
int neteqv P_((Queue * netq));
int getxslength P_((Stack * xs));
int getnetcnt P_((Queue * netq));
int inst_net_eqv P_((NetworkInstance * inst, Queue * cons));

/* parse.Y */
void stackfree P_((Stack *xs, int type));

/* parse.c */
int yyparse P_((void));

/* sig_init (); */
void signal_init P_((void));

/* slserr.c */
void sls_perror P_((char *s));
void sls_error P_((int lineno, int e_no, char * e_str));

/* simple.c */
void joinSimple P_((Netelem *dnet, Stack *dnet_xs, class ntwinst *inst,
		    Stack *inst_xs, Netelem *net, Stack *net_xs));
void outSimple P_((Queue *q));

/* to_db.c */
void term_to_db P_((Queue * q));
void inst_to_db P_((NetworkInstance * inst));
void net_to_db P_((Queue * q));

/* util.c */
Stack * stackcpy P_((Stack * stck));
Stack * xstackcpy P_((Stack * stck));
char * strsav P_((char * s));
void bmove P_((char *to, char *from, int l));

# ifdef __cplusplus
  }
# endif

