static char *SccsId = "@(#)proc_wire.c 4.1 (TU-Delft) 05/24/90";
/**********************************************************

Name/Version      : cldm/4.1

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : J. Annevelink
Creation date     : 18-May-1983
Modified by       : S. de Graaf
Modification date : 13-May-1987


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1987 , All rights reserved
**********************************************************/
#include "extern.h"

proc_wire ()
{
    register int i, sign, xl, xr, yb, yt;

    if (w_width <= 0) {
	pr_exit (014, 32, "wire");
	return;
    }

    --int_ind;

    for (i = 0; i <= int_ind; i++) {
	if (int_val[i] > 0)
	    sign = 1;
	else
	    if (int_val[i] < 0)
		sign = -1;
	    else {
		pr_exit (014, 31, "wire"); /* incr. value is 0 */
		return;
	    }

	if (w_dir == -1) {	/* add box in x-dir */
	    if (i > 0)
		xl = w_x - sign * w_width;
	    else
		xl = w_x;

	    w_x += int_val[i];

	    if (i < int_ind)
		xr = w_x + sign * w_width;
	    else
		xr = w_x;

	    yb = w_y - w_width;
	    yt = w_y + w_width;
	    w_dir = 1;
	}
	else {			/* add box in y-dir */
	    if (i > 0)
		yb = w_y - sign * w_width;
	    else
		yb = w_y;

	    w_y += int_val[i];

	    if (i < int_ind)
		yt = w_y + sign * w_width;
	    else
		yt = w_y;

	    xl = w_x - w_width;
	    xr = w_x + w_width;
	    w_dir = -1;
	}

	if ((xl & 1) || (xr & 1) || (yb & 1) || (yt & 1)) {
	    pr_exit (0614, 45, 0); /* coord not on lambda grid */
	}

	proc_box (xl / 2, xr / 2, yb / 2, yt / 2);
    }
}
