static char *SccsId = "@(#)ini_mtree.c 4.5 (TU-Delft) 01/15/91";
/**********************************************************

Name/Version      : cldm/4.5

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : J. Annevelink
Creation date     : 18-May-1983
Modified by       : S. de Graaf
Modification date : 17-Dec-1987
Modification date : 22-Apr-1988


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1987-1988, All rights reserved
**********************************************************/
#include "extern.h"

ini_modtree ()
{
    register char **ml;
    register IMPCELL **iml;
#if NCF_RELEASE >= 400
    register IMPCELL **tmp_iml;
#endif

    mod_tree = NULL;
    /*
     * For Release 4 the MODULELIST request retrieves
     * ALL module names.
     * Names of imported cells do not have to be retrieved
     * separately.  We only have to check whether a cell
     * is imported or not.
     */
#if NCF_RELEASE < 400
    if ((ml = (char **) dmGetMetaDesignData (CELLLIST, dmproject, LAYOUT))
#else
    if ((ml = (char **) dmGetMetaDesignData (MODULELIST, dmproject, LAYOUT))
#endif
	&& (iml = (IMPCELL **) dmGetMetaDesignData (IMPORTEDCELLLIST,
					dmproject, LAYOUT))) {
	for (; *ml; ++ml) {
	    if (append_tree (*ml, &mod_tree)) {
		pr_exit (0107, 4, *ml);
	    }
	    tree_ptr -> bbox = NULL;
#if NCF_RELEASE < 400
	    /* Rel3: celllist contains local cells only. */
	    tree_ptr -> impcell = 0;
#else
	    /* Rel4: check whether actual version is imported. */
	    for (tmp_iml = iml; *tmp_iml; ++tmp_iml) {
		if (strcmp (*ml, (*tmp_iml) -> alias) == 0) {
		    /* Cellname is name of imported cell. */
		    break;
		}
	    }
	    tree_ptr -> impcell = *tmp_iml;
#endif
	}

#if NCF_RELEASE < 400
	for (; *iml; ++iml) {
	    if (append_tree ((*iml) -> alias, &mod_tree)) {
		pr_exit (0107, 4, (*iml) -> alias);
	    }
	    tree_ptr -> bbox = NULL;
	    tree_ptr -> impcell = *iml;
	}
#endif
    }
}
