/*
 * malloc.h --
 *
 *	See malloc.c for a description of magic's allocation functions.
 *	Magic's built-in malloc() function has been removed.
 *
 * rcsid "$Header: /ufs/repository/magic/utils/malloc.h,v 1.2 2001/01/12 22:13:32 jsolomon Exp $"
 *
 *     ********************************************************************* 
 *     * Copyright (C) 1985, 1990 Regents of the University of California. * 
 *     * Permission to use, copy, modify, and distribute this              * 
 *     * software and its documentation for any purpose and without        * 
 *     * fee is hereby granted, provided that the above copyright          * 
 *     * notice appear in all copies.  The University of California        * 
 *     * makes no representations about the suitability of this            * 
 *     * software for any purpose.  It is provided "as is" without         * 
 *     * express or implied warranty.  Export of this software outside     * 
 *     * of the United States of America may require an export license.    * 
 *     *********************************************************************
 */

/*
 * The following are debugging flags for the memory allocator.
 * If any are enabled, the MALLOC() and FREE() macros become defined
 * as just procedure calls on mallocMagic() and freeMagic() respectively.  
 *
 * To ensure that the monitoring code in each of these procedures gets
 * executed for all allocations/frees, every module that uses the
 * MALLOC or FREE macros should be recompiled.  Modules that use
 * only the mallocMagic() or freeMagic() procedure calls do not need to be
 * recompiled.
 */

extern char *mallocMagic();
extern char *callocMagic();

/*
 * These macros should be removed as they are unnecessary and confusing
 * (since MALLOC uses mallocMagic(), not malloc()).  But they are all
 * over the source code, so they remain.
 */

#define	MALLOC(type, pt, n)   (pt) = (type) mallocMagic((unsigned) (n))
#define	CALLOC(type, pt, n)   (pt) = (type) callocMagic((unsigned) (n))
#define	FREE(cp)	      freeMagic(cp)

