/*--------------------------------------------------------------*/
/* tclroute.c							*/
/*								*/
/*	Allows the "router" feature to be loaded as a module	*/
/*	under the Tcl/Tk version of magic.  Loading is		*/
/*	automatic upon invoking one of the router commands.	*/
/*--------------------------------------------------------------*/

#ifdef ROUTE_AUTO

#include <stdio.h>
#include <string.h>

#include "magic/tclmagic.h"
#include "misc/magic.h"
#include "utils/geometry.h"
#include "tiles/tile.h"
#include "utils/hash.h"
#include "utils/doubleint.h"
#include "utils/heap.h"
#include "utils/list.h"
#include "database/database.h"
#include "windows/windows.h"
#include "commands/commands.h"
#include "tech/tech.h"

#include "router/router.h"
#include "gcr/gcr.h"
#include "grouter/grouter.h"
#include "mzrouter/mzrouter.h"

/* External routines */

extern Void CmdRoute(), CmdIRoute(), CmdGaRoute();
extern Void CmdChannel(), CmdSeeFlags();
extern Void CmdGARouterTest(), CmdGRouterTest();
extern Void CmdIRouterTest(), CmdMZRouterTest(); 

/*
 * ----------------------------------------------------------------------------
 *
 * Tcl package initialization function
 *
 * ----------------------------------------------------------------------------
 */

int
Tclroute_Init(interp)
    Tcl_Interp *interp;
{
    int n;
    SectionID invsec;

    /* Sanity checks! */
    if (interp == NULL) return TCL_ERROR;
    if (Tcl_PkgRequire(interp, "Tclmagic", "7.2", 0) == NULL) return TCL_ERROR;
    if (Tcl_InitStubs(interp, "8.1", 0) == NULL) return TCL_ERROR;

    TxPrintf("Auto-loading ROUTE module\n");
    TxFlushOut();

    /* Replace the auto-load function with the ones defined in	*/
    /* this package in the command functions list.		*/

    for (n = 0; CmdLongCommands[n] != NULL; n++)
    {
	if (!strncmp(CmdLongCommands[n], "route", 5))
	    CmdFuncs[n] = CmdRoute;
	else if (!strncmp(CmdLongCommands[n], "garoute", 7))
	    CmdFuncs[n] = CmdGaRoute;
	else if (!strncmp(CmdLongCommands[n], "iroute", 6))
	    CmdFuncs[n] = CmdIRoute;
	else if (!strncmp(CmdLongCommands[n], "channels", 8))
	    CmdFuncs[n] = CmdChannel;
	else if (!strncmp(CmdLongCommands[n], "*garoute", 8))
	    CmdFuncs[n] = CmdGARouterTest;
	else if (!strncmp(CmdLongCommands[n], "*groute", 7))
	    CmdFuncs[n] = CmdGRouterTest;
	else if (!strncmp(CmdLongCommands[n], "*iroute", 7))
	    CmdFuncs[n] = CmdIRouterTest;
	else if (!strncmp(CmdLongCommands[n], "*mzroute", 8))
	    CmdFuncs[n] = CmdMZRouterTest;
	else if (!strncmp(CmdLongCommands[n], "*seeflags", 9))
	    CmdFuncs[n] = CmdSeeFlags;
    }

    /* Now we need to do TechAddClient and reload the tech file */

    TechAddClient("mzrouter", MZTechInit, MZTechLine, MZTechFinal,
		(SectionID) 0, (SectionID *) 0, FALSE);
    TechAddClient("drc", MZDRCInit, MZDRCLine, MZDRCFinal,
		(SectionID) 0, (SectionID *) 0, FALSE);
    TechAddClient("router", RtrTechInit, RtrTechLine, RtrTechFinal,
		(SectionID) 0, (SectionID *) 0, FALSE);

    /* Initialization functions */
    NMinit();
    MZInit();
    IRInit();

    invsec = TechSectionGetMask("drc", NULL);
    invsec &= TechSectionGetMask("mzrouter", NULL);
    invsec &= TechSectionGetMask("router", NULL);
    if (!TechLoad(TechDefault, invsec)) return TCL_ERROR;

    Tcl_PkgProvide(interp, "Route", "7.2");
    return TCL_OK;
}

#endif /* ROUTE_AUTO */
