/*--------------------------------------------------------------*/
/* tclplow.c							*/
/*								*/
/*	Allows the "plow" feature to be loaded as a module	*/
/*	under the Tcl/Tk version of magic.  Loading is		*/
/*	automatic upon invoking the "plow", "straighten", or	*/
/*	"*plowtest" command.					*/
/*--------------------------------------------------------------*/

#ifdef PLOW_AUTO

#include <stdio.h>
#include <string.h>

#include "magic/tclmagic.h"
#include "misc/magic.h"
#include "utils/geometry.h"
#include "tiles/tile.h"
#include "utils/hash.h"
#include "database/database.h"
#include "windows/windows.h"
#include "commands/commands.h"
#include "tech/tech.h"
#include "plow/plow.h"

/* External routines */

extern Void CmdPlow(), CmdPlowTest(), CmdStraighten();

/*
 * ----------------------------------------------------------------------------
 *
 * Tcl package initialization function
 *
 * ----------------------------------------------------------------------------
 */

int
Tclplow_Init(interp)
    Tcl_Interp *interp;
{
    int n;
    SectionID invsec;

    /* Sanity checks! */
    if (interp == NULL) return TCL_ERROR;
    if (Tcl_PkgRequire(interp, "Tclmagic", "7.2", 0) == NULL) return TCL_ERROR;
    if (Tcl_InitStubs(interp, "8.1", 0) == NULL) return TCL_ERROR;

    TxPrintf("Auto-loading PLOW module\n");
    TxFlushOut();

    /* Replace the auto-load function with the ones defined in	*/
    /* this package in the command functions list.		*/

    for (n = 0; CmdLongCommands[n] != NULL; n++)
    {
	if (!strncmp(CmdLongCommands[n], "*plow", 5))
	    CmdFuncs[n] = CmdPlowTest;
	else if (!strncmp(CmdLongCommands[n], "plow", 4))
	    CmdFuncs[n] = CmdPlow;
	else if (!strncmp(CmdLongCommands[n], "straighten", 10))
	    CmdFuncs[n] = CmdStraighten;
    }

    /* Now we need to do TechAddClient and reload the tech file */

    TechAddClient("drc", PlowDRCInit, PlowDRCLine, PlowDRCFinal,
		(SectionID) 0, (SectionID *) 0, FALSE);
    TechAddClient("plowing", PlowTechInit, PlowTechLine, PlowTechFinal,
		(SectionID) 0, (SectionID *) 0, FALSE);

    PlowInit();

    invsec = TechSectionGetMask("drc", NULL);
    invsec &= TechSectionGetMask("plowing", NULL);
    if (!TechLoad(TechDefault, invsec)) return TCL_ERROR;

    Tcl_PkgProvide(interp, "Plow", "7.2");
    return TCL_OK;
}

#endif /* PLOW_AUTO */
