/*
 * patchlevel.c --
 *
 * Keeps track of patches.
 *
 *     ********************************************************************* 
 *     * Copyright (C) 1985, 1990 Regents of the University of California. * 
 *     * Permission to use, copy, modify, and distribute this              * 
 *     * software and its documentation for any purpose and without        * 
 *     * fee is hereby granted, provided that the above copyright          * 
 *     * notice appear in all copies.  The University of California        * 
 *     * makes no representations about the suitability of this            * 
 *     * software for any purpose.  It is provided "as is" without         * 
 *     * express or implied warranty.  Export of this software outside     * 
 *     * of the United States of America may require an export license.    * 
 *     *********************************************************************
 */

#ifndef lint
static char rcsid[]="$Header: /ufs/repository/magic/misc/patchlevel.c,v 1.2 2001/01/12 22:13:00 jsolomon Exp $";
#endif  not lint

#include <stdio.h>
#include "misc/magic.h"
#include "misc/patchlevel.h"

int PatchLevel = 0;

/*
 * ----------------------------------------------------------------------------
 *
 * PatchNames --
 *
 * Keep track of patches.
 *
 * Results:
 *	A string describing patches that where made.
 *
 * Side effects:
 *	None.
 * ----------------------------------------------------------------------------
 */

static char patchstr[1000];

char *
PatchNames()
{

    strcpy(patchstr, "release-6.5b1");
    strcat(patchstr, ", linux1, solaris1");
    strcat(patchstr, ", SU-WRL-extract");
    strcat(patchstr, ", WRL-DRC-X");
    strcat(patchstr, ", UNC-CIF-X");

    /* Here are some example patch lines.  Pick a name for each of your 
     * patches.  Use the ":version" command to see what patches are install
     * in magic already.
    strcat(patchstr, ", ext-lumped");
    strcat(patchstr, ", calma-bbox");
    strcat(patchstr, ", cif-read1");
    */
    /* NEW PATCH LINES GO RIGHT BEFORE THIS LINE */
    return patchstr;
}
