# Wishrc startup for ToolScript (magic)
#
# For installation:  Put this file and also magicwrap.so into
# directory ${CAD_HOME}/lib/magic/tcl/, and set the "load" line below
# to point to the location of magicwrap.so.  Also see comments
# in shell script "magic.sh".
# 

load TCL_DIR/tclmagicSHDLIB_EXT

# It is important to make sure no magic commands overlap with Tcl built-in
# commands, because otherwise the namespace import will fail.

proc pushnamespace { name } {

   set y [namespace eval ${name} info commands ::${name}::*]
   set z [info commands]

# Watch especially for magic "wizard" commands, as we don't want to confuse
# the literal "*" with a regular expression *.  "regsub" below takes care of it.

   foreach v $y {
      regsub -all {\*} $v {\\*} i
      set x [namespace tail $i]
      if {[lsearch $z $x] < 0} { 
         namespace import $i                       
      } else {

#	 This works but is inherently dangerous---in particular, renaming
#	 the original Tcl commands plays havoc with Tcl's "history" function.
#
#	 if {![catch {rename ::$x ::${name}_tcl_$x}]} {
#	    interp alias {} ::$x {} ::${name}::$x
#	    puts "Warning: '$x' is equivalent to '${name}::$x'"
#	    puts "         Use '${name}_tcl_$x' for the original Tcl command"
#	 } else {
            puts "Warning: ${name} command '$x' use fully-qualified name '$v'"
#        }
      }
   }
}

proc popnamespace { name } {
   set z [info commands]
   set l [expr [string length ${name}] + 5]

   while {[set v [lsearch $z ${name}_tcl_*]] >= 0} {
      set y [lindex $z $v]
      set w [string range $y $l end]
      interp alias {} ::$w {}
      rename ::$y ::$w
      puts "Info: replacing ::$w with ::$y"
   }
   namespace forget ::${name}::*
}

set auto_noexec 1	;# don't EVER call UNIX commands w/o "shell" in front

# Have we called magic from tkcon or a clone thereof?  If so, set MagicConsole

if {[lsearch [interp aliases] tkcon] != -1} {
   set MagicConsole tkcon
   wm withdraw .

# Rename conflicting TkCon commands before pushing magic's namespace
   rename ::echo ::tkecho
   rename ::edit ::tkedit
   rename ::dump ::tkdump
   rename ::what ::tkwhat
}

pushnamespace magic

# Parse argument list for "-c[onsole]".

set cellname ""
set argv [string range $argv 1 end]
if {[string length $argv] == 0} {
   magic::start
} else {
   set argafter {magic::start}
   for {set i 0} {$i < $argc} {incr i 1} {
      set x [lindex $argv $i]
#
# Command-line argument handling goes here
# We have to handle all of magic's command line arguments so we can
# figure out if a cell has been named for preloading.
#
      switch -regexp -- $x {
	 ^-w(rap)?(per)?$ {	  ;# This regexp accepts -w, -wrap, and -wrapper
	    source TCL_DIR/wrapper.tcl
	    lappend argafter "-nowindow" ;# Set no-initial-window option in magic.
	 }
	 -g -
	 -d -
	 -m -
	 -i -
	 -T {
	    lappend argafter $x
	    incr i 1
	    lappend argafter [lindex $argv $i]
	 }
	 -F {
	    lappend argafter $x
	    incr i 1
	    lappend argafter [lindex $argv $i]
	    incr i 1
	    lappend argafter [lindex $argv $i]
	 }
	 -D -
	 -n* {
	    lappend argafter $x
	 }
	 default {
	    set cellname $x
	    lappend argafter $x
	 }
      }
   }
   eval $argafter 	;# magic::start ${argv}
}

# Don't load the exttospice module, but allow it to auto-load when it is
# called.  The dummy procedure "exttospice" will be overwritten by the
# real one, and then the real procedure will be called.

proc exttospice { args } {
   rename exttospice {}
   load TCL_DIR/exttospiceSHDLIB_EXT
   pushnamespace exttospice
   eval {exttospice::exttospice} $args
}

# Set up auto-load of exttosim like exttospice, above.

proc exttosim { args } {
   rename exttosim {}
   load TCL_DIR/exttosimSHDLIB_EXT
   pushnamespace exttosim
   eval {exttosim::exttosim} $args
}

# Setup IRSIM assuming that the Tcl version is installed.
# We do not need to rename procedure startirsim to NULL because it is
# redefined in a script, which simply overwrites the original.

proc startirsim { args } {
   global CAD_HOME
   set irsimscript [glob -nocomplain ${CAD_HOME}/lib/irsim/tcl/irsim.tcl]
   if { ${irsimscript} == {} } {
      puts stderr "\"startirsim\" requires Tcl-based IRSIM version 9.6."
      puts stderr "Could not find script \"irsim.tcl\".  If IRSIM is installed in a"
      puts stderr "place other than CAD_HOME (=${CAD_HOME}), use the command"
      puts stderr "\"source <path>/irsim.tcl\" before doing \"startirsim\"."
   } else {
      source $irsimscript
      eval {startirsim} $args
   }
}

# Magic start function drops back to interpreter after initialization & setup

if {[string range [wm title .] 0 3] == "wish"} {
   wm withdraw .
}

# Initial geometry handler, if the default window is used

catch {wm geometry .magic1 1000x750+100+100}

# Initial window for wrapper, if defined.
# empty string is equivalent to passing NULL cell name.

if {![catch {set winname [magic::openwrapper $cellname]}]} {
   magic::techmanager initall
   magic::scrollupdate $winname
}
unset cellname
