#!/bin/sh
#
# For installation, put this file (magic.sh) in ${CAD_HOME}/bin/magic.
# Put startup script "magic.tcl" and shared library "tclmagic.so"
# in ${CAD_HOME}/lib/magic/tcl/, with a symbolic link from file
# ".wishrc" to "magic.tcl".
#
# This script starts magic under the Tcl interpreter,
# reading commands from a special .wishrc script which
# launches magic and retains the Tcl interactive interpreter.

# Parse for the argument "-c[onsole]".  If it exists, run magic
# with the TkCon console.  Strip this argument from the argument list.

TKCON=true

for i in $@ ; do
   case $i in
      -noc*) TKCON=;;
   esac
done

if [ $TKCON ]; then

   exec TCL_DIR/tkcon.tcl -eval "source TCL_DIR/console.tcl" \
	-slave "package require Tk; set argc $#; set argv [list -$*]; \
	source TCL_DIR/magic.tcl"

#  exec TCL_DIR/tkcon.tcl -exec "" -eval \
#	"set argc $#; set argv [list -$*]; source TCL_DIR/magic.tcl"

else

   export HOME=TCL_DIR
#
# Make sure that the following points to your current wish
# executable, whereever it may be.
#
   exec wish -- -$@

fi
