/*
 * macros.h --
 *
 * Routines to define and retrieve macros
 *
 *     ********************************************************************* 
 *     * Copyright (C) 1985, 1990 Regents of the University of California. * 
 *     * Permission to use, copy, modify, and distribute this              * 
 *     * software and its documentation for any purpose and without        * 
 *     * fee is hereby granted, provided that the above copyright          * 
 *     * notice appear in all copies.  The University of California        * 
 *     * makes no representations about the suitability of this            * 
 *     * software for any purpose.  It is provided "as is" without         * 
 *     * express or implied warranty.  Export of this software outside     * 
 *     * of the United States of America may require an export license.    * 
 *     *********************************************************************
 *
 *
 * rcsid "$Header: /ufs/repository/magic/macros/macros.h,v 1.4 2001/02/22 15:12:25 tim Exp $"
 */

#define _MACROS
#ifndef	_MAGIC
	err = Need_to_include_misc/magic_h
#endif

/*
 * Macro data structure
 */
 
typedef struct _macrodef *macroptr;

typedef struct _macrodef {
   bool interactive;
   int  keyvalue;		/* X11 keycode */
   char *macrodef;
   macroptr nextmacro;
} macrodef;

/* macro table start */
extern macrodef *mactable;

/* procedures */
extern void MacroDefine();
extern void MacroDefineInt();
extern char *MacroRetrieve();	/* returns a malloc'ed string */
extern void MacroDelete();
extern char *MacroName();	/* returns a malloc'ed string */
extern int MacroKey();
extern int MacroCode();
