/*
 * grTkInt.h --
 *
 * Internal definitions for grTk[1..5].c.
 *
 * NOTE:  In order for the these defs to work correctly, this file
 * (grXInt.h) must be included after all the Magic .h files and before
 * the X .h files.
 */

/* Constants
 */
#define M_WIDTH		1023
#define M_HEIGHT	750

#define MAX_CURSORS	32	/* Maximum number of programmable cursors */

#define GR_DEFAULT_FONT "9x15"
#define TK_BATCH_SIZE	10000

#define true		1
#define false		0

#undef TRUE

#define grMagicToX(y) ( grCurrent.mw->w_allArea.r_ytop - (y))
#define grXToMagic(y) ( grCurrent.mw->w_allArea.r_ytop - (y))

/*
 * Our default fonts for Tk.
 */

#define	TK_FONT_SMALL	"-*-helvetica-medium-r-normal--10-*-75-75-p-*-iso8859-*"
#define	TK_FONT_MEDIUM	"-*-helvetica-medium-r-normal--14-*-75-75-p-*-iso8859-*"
#define	TK_FONT_LARGE	"-*-helvetica-medium-r-normal--18-*-75-75-p-*-iso8859-*"
#define	TK_FONT_XLARGE 	"-*-helvetica-medium-r-normal--24-*-75-75-p-*-iso8859-*"

/* Macro for conversion between X and Magic coordinates
 */

/* Current settings for X function parameters */
typedef struct {
    XFontStruct 	*font;
    Cursor		cursor;
    int			fontSize;
    int			maskmod;
    Tk_Window 		window;
    Window		windowid;
    MagWindow		*mw;
} GR_CURRENT;

typedef struct {
    unsigned long	basepixel;
    unsigned long	planes[32];
    int			depth;
    int			planeCount;
    int			colorCount;
    int			realColors;
    int			red_mask;
    int			green_mask;
    int			blue_mask;
} GR_DISPLAY;

extern Display *grXdpy;
extern Colormap grXcmap;
extern int	grXscrn;
extern unsigned long grPixels[];
extern unsigned long grPlanes[];
extern GR_CURRENT grCurrent;
extern GR_DISPLAY grDisplay;
extern GC grGCFill, grGCText, grGCDraw, grGCCopy, grGCGlyph;

extern bool grtkGetCursorPos();
extern bool grtkDrawGrid();
extern Void GrTkEnableTablet();
extern Void GrTkDisableTablet();
extern Void GrTkSetCMap();
extern Void grtkPutText();
extern Void grtkDefineCursor();
extern Void GrTkSetCursor();
extern Void GrTkTextSize();
extern Void GrTkDrawGlyph();
extern Void GrTkBitBlt();
extern Void NullBitBlt();
extern int  GrTkReadPixel();
extern Void grtkDrawLine();
extern Void grtkSetLineStyle();
extern Void grtkSetCharSize();
extern Void grtkSetWMandC();
extern Void grtkFillRect();
extern Void grtkRectConvert();
#ifdef NONMANHATTAN
extern Void grtkFillPolygon();
#endif

extern Void grtkDrawLines();
extern XSegment grtkLines[];
extern int grtkNbLines;
extern Void grtkFillRects();
extern XRectangle grtkRects[];
extern int grtkNbRects;

#define GR_TK_FLUSH_LINES() {if (grtkNbLines>0) {grtkDrawLines(grtkLines, grtkNbLines); grtkNbLines=0;}}
#define GR_TK_FLUSH_RECTS() {if (grtkNbRects>0) {grtkFillRects(grtkRects, grtkNbRects); grtkNbRects=0;}}
#define	GR_TK_FLUSH_BATCH() {GR_TK_FLUSH_LINES(); GR_TK_FLUSH_RECTS();}

