/*
 * grTOGLInt.h --
 *
 * Internal definitions for grTOGL[1..5].c.
 *
 * NOTE:  In order for the these defs to work correctly, this file
 * (grTOGLInt.h) must be included after all the Magic .h files and before
 * the X11, OpenGL, and Tk/Tcl .h files.
 */

/* Constants
 */
#define M_WIDTH		1023
#define M_HEIGHT	750

#define MAX_CURSORS	32	/* Maximum number of programmable cursors */

#define GR_DEFAULT_FONT "9x15"
#define TOGL_BATCH_SIZE	10000

#define true		1
#define false		0

#undef TRUE

/* Macro for conversion between X and Magic coordinates
 */

#define glTransY(mw, n)	( mw->w_allArea.r_ytop - (n) )

/*
 * Our default fonts for X11.
 */

#define	TK_FONT_SMALL	"-*-helvetica-medium-r-normal--10-*-75-75-p-*-iso8859-*"
#define	TK_FONT_MEDIUM	"-*-helvetica-medium-r-normal--14-*-75-75-p-*-iso8859-*"
#define	TK_FONT_LARGE	"-*-helvetica-medium-r-normal--18-*-75-75-p-*-iso8859-*"
#define	TK_FONT_XLARGE 	"-*-helvetica-medium-r-normal--24-*-75-75-p-*-iso8859-*"

/* Current settings for X function parameters */
typedef struct {
    XFontStruct 	*font;
    Cursor		cursor;
    int			fontSize;
    int			depth;
    int			maskmod;
    Tk_Window 		window;
    Window		windowid;
    MagWindow		*mw;
} TOGL_CURRENT;

#ifdef OGL_SERVER_SIDE_ONLY
typedef Rect TOGLRect;
#else

/* Used for vertex arrays */
typedef struct {
    Point r_ll, r_ul, r_ur, r_lr;
} TOGLRect;

#endif

extern TOGL_CURRENT toglCurrent;

extern bool grtoglGetCursorPos();
extern bool grtoglDrawGrid();
extern Void GrTOGLEnableTablet();
extern Void GrTOGLDisableTablet();
extern Void GrTOGLSetCMap();
extern Void grtoglPutText();
extern Void grtoglDefineCursor();
extern Void GrTOGLSetCursor();
extern Void GrTOGLTextSize();
extern Void GrTOGLDrawGlyph();
extern Void GrTOGLBitBlt();
extern Void NullBitBlt();
extern int  GrTOGLReadPixel();
extern Void grtoglDrawLine();
extern Void grtoglSetLineStyle();
extern Void grtoglSetCharSize();
extern Void grtoglSetWMandC();
extern Void grtoglFillRect();
extern Void grtoglRectConvert();
#ifdef NONMANHATTAN
extern Void grtoglFillPolygon();
#endif

extern int grtoglNbLines;
extern int grtoglNbRects;

extern Void grtoglDrawLines();
extern Void grtoglDrawLine();
extern Void grtoglSetLineStyle();
extern Void grtoglFillRect();
extern Void grtoglFillRects();
#ifdef NONMANHATTAN
extern Void grtoglFillPolygon();
#endif

extern Rect grtoglLines[];
extern TOGLRect grtoglRects[];

#define GR_TOGL_FLUSH_LINES() {if (grtoglNbLines>0) {grtoglDrawLines(grtoglLines, grtoglNbLines); grtoglNbLines=0;}}
#define GR_TOGL_FLUSH_RECTS() {if (grtoglNbRects>0) {grtoglFillRects(grtoglRects, grtoglNbRects); grtoglNbRects=0;}}
#define	GR_TOGL_FLUSH_BATCH() {GR_TOGL_FLUSH_LINES(); GR_TOGL_FLUSH_RECTS();}
